/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.responses;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureResults;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.wfs.requests.FeatureRequest;

public class GetFeatureResults {
    private final FeatureRequest request;
    private FeatureLock featureLock;
    private List features;
    private List typeInfo;

    public GetFeatureResults(FeatureRequest request) {
        this.request = request;
        this.features = new ArrayList(2);
        this.typeInfo = new ArrayList(2);
    }

    public FeatureRequest getRequest() {
        return this.request;
    }

    public FeatureLock getFeatureLock() {
        return this.featureLock;
    }

    public void setFeatureLock(FeatureLock featureLock) {
        this.featureLock = featureLock;
    }

    public int getResultsetsCount() {
        return this.features.size();
    }

    public FeatureResults getFeatures(int index) throws ArrayIndexOutOfBoundsException {
        return (FeatureResults)this.features.get(index);
    }

    public FeatureTypeInfo getTypeInfo(int index) throws ArrayIndexOutOfBoundsException {
        return (FeatureTypeInfo)this.typeInfo.get(index);
    }

    public List getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public List getTypesInfo() {
        return Collections.unmodifiableList(this.typeInfo);
    }

    public void addFeatures(FeatureTypeInfo meta, FeatureResults features) throws IOException {
        if (meta == null || features == null) {
            throw new NullPointerException("Both the metadata and results of querying a featuretype must be passed");
        }
        if (!features.getSchema().getTypeName().equals(meta.getFeatureType().getTypeName())) {
            throw new IllegalArgumentException("The passed type info and results do not seems to belong to the same type");
        }
        this.typeInfo.add(meta);
        this.features.add(features);
    }
}

