/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.responses;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureSource;
import org.geotools.data.Transaction;
import org.geotools.factory.FactoryFinder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.AttributeTypeInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wfs.FeatureResponseDelegateProducerSpi;
import org.vfny.geoserver.wfs.Query;
import org.vfny.geoserver.wfs.WfsException;
import org.vfny.geoserver.wfs.requests.FeatureRequest;
import org.vfny.geoserver.wfs.requests.FeatureWithLockRequest;
import org.vfny.geoserver.wfs.responses.FeatureResponseDelegate;
import org.vfny.geoserver.wfs.responses.GetFeatureResults;

public class FeatureResponse
implements Response {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses");
    FeatureResponseDelegate delegate;
    private FeatureRequest request = null;
    FeatureLock featureLock = null;
    static /* synthetic */ Class class$org$vfny$geoserver$wfs$FeatureResponseDelegateProducerSpi;

    public HashMap getResponseHeaders() {
        return null;
    }

    public String getContentType(GeoServer gs) {
        return this.delegate.getContentType(gs);
    }

    public String getContentEncoding() {
        return this.delegate.getContentEncoding();
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        if (this.request == null || this.delegate == null) {
            throw new IllegalStateException("execute has not been called prior to writeTo");
        }
        this.delegate.encode(out);
    }

    public void execute(Request req) throws ServiceException {
        this.execute((FeatureRequest)req);
    }

    public static FeatureResponseDelegate getDelegate(String outputFormat) throws NoSuchElementException {
        Iterator spi_it = FactoryFinder.factories((Class)(class$org$vfny$geoserver$wfs$FeatureResponseDelegateProducerSpi == null ? (class$org$vfny$geoserver$wfs$FeatureResponseDelegateProducerSpi = FeatureResponse.class$("org.vfny.geoserver.wfs.FeatureResponseDelegateProducerSpi")) : class$org$vfny$geoserver$wfs$FeatureResponseDelegateProducerSpi));
        while (spi_it.hasNext()) {
            FeatureResponseDelegateProducerSpi spi = (FeatureResponseDelegateProducerSpi)spi_it.next();
            if (!spi.canProduce(outputFormat)) continue;
            return spi.createFeatureDelegateProducer(outputFormat);
        }
        throw new NoSuchElementException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FeatureRequest request) throws ServiceException {
        LOGGER.finest("execute FeatureRequest response. Called request is: " + (Object)((Object)request));
        this.request = request;
        String outputFormat = request.getOutputFormat();
        try {
            this.delegate = FeatureResponse.getDelegate(outputFormat);
        }
        catch (NoSuchElementException ex) {
            throw new WfsException("output format: " + outputFormat + " not " + "supported by geoserver", ex);
        }
        if (request instanceof FeatureWithLockRequest) {
            this.featureLock = ((FeatureWithLockRequest)request).toFeatureLock();
            String authorization = this.featureLock.getAuthorization();
            LOGGER.finest("FeatureWithLock using Lock:" + authorization);
        }
        GetFeatureResults results = new GetFeatureResults(request);
        results.setFeatureLock(this.featureLock);
        GeoServer config = request.getWFS().getGeoServer();
        Data catalog = request.getWFS().getData();
        FeatureTypeInfo meta = null;
        int maxFeatures = request.getMaxFeatures();
        int serverMaxFeatures = config.getMaxFeatures();
        if (maxFeatures > serverMaxFeatures) {
            maxFeatures = serverMaxFeatures;
        }
        HashSet<String> lockedFids = new HashSet<String>();
        HashSet<String> lockFailedFids = new HashSet<String>();
        FilterFactory filterFactory = FilterFactoryFinder.createFilterFactory();
        try {
            Iterator it = request.getQueries().iterator();
            while (it.hasNext() && maxFeatures > 0) {
                Query query = (Query)it.next();
                meta = catalog.getFeatureTypeInfo(query.getTypeName());
                NameSpaceInfo namespace = meta.getDataStoreInfo().getNameSpace();
                FeatureSource source = meta.getFeatureSource();
                List attrs = meta.getAttributes();
                List propNames = query.getPropertyNames();
                List attributeNames = meta.getAttributeNames();
                Iterator iter = propNames.iterator();
                while (iter.hasNext()) {
                    String propName = (String)iter.next();
                    if (attributeNames.contains(propName)) continue;
                    String mesg = "Requested property: " + propName + " is " + "not available for " + query.getTypeName() + ".  " + "The possible propertyName values are: " + attributeNames;
                    throw new WfsException(mesg);
                }
                if (propNames.size() != 0) {
                    Iterator ii = attrs.iterator();
                    LinkedList<String> tmp = new LinkedList<String>();
                    while (ii.hasNext()) {
                        AttributeTypeInfo ati = (AttributeTypeInfo)ii.next();
                        LOGGER.finer("checking to see if " + propNames + " contains" + ati);
                        if ((ati.getMinOccurs() <= 0 || ati.getMaxOccurs() == 0) && !propNames.contains(ati.getName())) continue;
                        tmp.add(ati.getName());
                    }
                    query.setPropertyNames(tmp);
                }
                LOGGER.fine("Query is " + query + "\n To gt2: " + query.toDataQuery(maxFeatures));
                FeatureCollection features = source.getFeatures(query.toDataQuery(maxFeatures));
                if (it.hasNext()) {
                    maxFeatures -= features.getCount();
                }
                results.addFeatures(meta, (FeatureResults)features);
                if (this.featureLock == null) continue;
                if (source instanceof FeatureLocking) {
                    ((FeatureLocking)source).setFeatureLock(this.featureLock);
                }
                FeatureReader reader = null;
                try {
                    reader = features.reader();
                    while (reader.hasNext()) {
                        Feature feature = reader.next();
                        String fid = feature.getID();
                        if (!(source instanceof FeatureLocking)) {
                            LOGGER.finest("Lock " + fid + " not supported by data store (authID:" + this.featureLock.getAuthorization() + ")");
                            lockFailedFids.add(fid);
                            continue;
                        }
                        FidFilter fidFilter = filterFactory.createFidFilter(fid);
                        int numberLocked = ((FeatureLocking)source).lockFeatures((Filter)fidFilter);
                        if (numberLocked == 1) {
                            LOGGER.finest("Lock " + fid + " (authID:" + this.featureLock.getAuthorization() + ")");
                            lockedFids.add(fid);
                            continue;
                        }
                        if (numberLocked == 0) {
                            LOGGER.finest("Lock " + fid + " conflict (authID:" + this.featureLock.getAuthorization() + ")");
                            lockFailedFids.add(fid);
                            continue;
                        }
                        LOGGER.warning("Lock " + numberLocked + " " + fid + " (authID:" + this.featureLock.getAuthorization() + ") duplicated FeatureID!");
                        lockedFids.add(fid);
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                if (lockedFids.isEmpty()) continue;
                DefaultTransaction t = new DefaultTransaction();
                try {
                    t.addAuthorization(this.featureLock.getAuthorization());
                    source.getDataStore().getLockingManager().refresh(this.featureLock.getAuthorization(), (Transaction)t);
                }
                finally {
                    t.commit();
                }
            }
            this.delegate.prepare(outputFormat, results);
            if (this.featureLock != null && !lockFailedFids.isEmpty()) {
                throw new WfsException("Could not aquire locks for:" + lockFailedFids);
            }
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e, "problem with FeatureResults", request.getHandle());
        }
        catch (NoSuchElementException e) {
            throw new ServiceException((Throwable)e, "problem with FeatureResults", request.getHandle());
        }
        catch (IllegalAttributeException e) {
            throw new ServiceException((Throwable)e, "problem with FeatureResults", request.getHandle());
        }
    }

    private static String getLocator(Query query) {
        String locator = query.getHandle();
        if (locator == null || locator.equals("")) {
            locator = "Class FeatureResponse, in method getQuery";
        }
        return locator;
    }

    private static FeatureResults getFeatures(Query query, FeatureTypeInfo meta, int maxFeatures) throws WfsException {
        LOGGER.finest("about to get query: " + query);
        List propertyNames = null;
        if (!query.allRequested()) {
            propertyNames = query.getPropertyNames();
        }
        FeatureCollection features = null;
        try {
            FeatureSource data = meta.getFeatureSource();
            LOGGER.finest("filter is " + query.getFilter());
            if (!query.allRequested()) {
                AttributeType[] mandatoryProps = meta.getFeatureType().getAttributeTypes();
                for (int i = 0; i < mandatoryProps.length; ++i) {
                    query.addPropertyName(mandatoryProps[i].getName());
                }
            }
            org.geotools.data.Query dsQuery = query.getDataSourceQuery(maxFeatures);
            features = data.getFeatures(dsQuery);
        }
        catch (IOException e) {
            throw new WfsException(e, "While getting features from datasource", FeatureResponse.getLocator(query));
        }
        LOGGER.finest("successfully retrieved collection");
        return features;
    }

    public void abort(Service gs) {
        if (this.request == null) {
            return;
        }
        if (this.featureLock == null) {
            return;
        }
        Data catalog = gs.getData();
        catalog.lockRelease(this.featureLock.getAuthorization());
    }

    public String getContentDisposition() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

