/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests.readers;

import java.io.IOException;
import java.io.Reader;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.vfny.geoserver.wfs.requests.TransactionFeatureHandler;
import org.vfny.geoserver.wfs.requests.TransactionFilterHandler;
import org.vfny.geoserver.wfs.requests.TransactionHandler;
import org.vfny.geoserver.wfs.requests.TransactionRequest;
import org.vfny.geoserver.wfs.responses.WfsTransactionException;
import org.vfny.geoserver.wfs.servlets.WFService;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;

public class TransactionXmlReader
extends XmlRequestReader {
    public TransactionXmlReader(WFService service) {
        super((AbstractService)service);
    }

    public Request read(Reader reader, HttpServletRequest req) throws WfsTransactionException {
        InputSource requestSource = new InputSource(reader);
        TransactionHandler contentHandler = new TransactionHandler((WFService)this.getServiceRef());
        TransactionFilterHandler filterParser = new TransactionFilterHandler(contentHandler, null);
        Data catalog = this.getServiceRef().getCatalog();
        TransactionFeatureHandler featureParser = new TransactionFeatureHandler(filterParser, req, catalog);
        GMLFilterGeometry geometryFilter = new GMLFilterGeometry((GMLHandlerJTS)featureParser);
        GMLFilterDocument documentFilter = new GMLFilterDocument((GMLHandlerGeometry)geometryFilter);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ParserAdapter adapter = new ParserAdapter(parser.getParser());
            adapter.setContentHandler((ContentHandler)documentFilter);
            XmlRequestReader.LOGGER.finest("about to start parsing");
            adapter.parse(requestSource);
            XmlRequestReader.LOGGER.finer("just parsed: " + requestSource);
        }
        catch (SAXException e) {
            throw new WfsTransactionException(e, "XML transaction request SAX parsing error", ((Object)((Object)this)).getClass().getName());
        }
        catch (IOException e) {
            throw new WfsTransactionException(e, "XML transaction request input error", ((Object)((Object)this)).getClass().getName());
        }
        catch (ParserConfigurationException e) {
            throw new WfsTransactionException(e, "Some sort of issue creating parser", ((Object)((Object)this)).getClass().getName());
        }
        TransactionRequest r = contentHandler.getRequest(req);
        return r;
    }
}

