/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests.readers;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geotools.filter.Filter;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wfs.WfsException;
import org.vfny.geoserver.wfs.requests.DeleteRequest;
import org.vfny.geoserver.wfs.requests.TransactionRequest;
import org.vfny.geoserver.wfs.requests.WfsKvpRequestReader;
import org.vfny.geoserver.wfs.servlets.WFService;

public class DeleteKvpReader
extends WfsKvpRequestReader {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.readers");

    public DeleteKvpReader(Map kvpPairs, WFService service) {
        super(kvpPairs, service);
    }

    public Request getRequest(HttpServletRequest request) throws WfsException {
        int filterSize;
        TransactionRequest parentRequest = new TransactionRequest((WFService)this.service);
        parentRequest.setHttpServletRequest(request);
        boolean releaseAll = true;
        LOGGER.finest("setting global request parameters");
        if (this.keyExists("VERSION")) {
            parentRequest.setVersion(this.getValue("VERSION"));
        }
        if (this.keyExists("REQUEST")) {
            parentRequest.setRequest(this.getValue("REQUEST"));
        }
        if (this.keyExists("LOCKID")) {
            parentRequest.setLockId(this.getValue("LOCKID"));
        }
        LOGGER.finest("setting query request parameters");
        List typeList = KvpRequestReader.readFlat((String)this.getValue("TYPENAME"), (String)",");
        LOGGER.finest("type list size: " + typeList.size());
        List filterList = null;
        filterList = WfsKvpRequestReader.readFilters(this.getValue("FEATUREID"), this.getValue("FILTER"), this.getValue("BBOX"));
        if (typeList.size() == 0 && (typeList = KvpRequestReader.getTypesFromFids((String)this.getValue("FEATUREID"))).size() == 0) {
            throw new WfsException("The typename element is mandatory if no FEATUREID is present");
        }
        int featureSize = typeList.size();
        int n = filterSize = filterList == null ? 0 : filterList.size();
        if (this.keyExists("RELEASEACTION")) {
            String lockAction = this.getValue("RELEASEACTION");
            parentRequest.setReleaseAction(lockAction);
        }
        if (filterSize != featureSize && filterSize > 0 || filterSize > 0 && featureSize == 0) {
            throw new WfsException("Filter size does not match feature types.  Filter size: " + filterSize + " Feature size: " + featureSize);
        }
        if (filterSize == featureSize) {
            int n2 = featureSize;
            for (int i = 0; i < n2; ++i) {
                DeleteRequest childRequest = new DeleteRequest();
                childRequest.setTypeName((String)typeList.get(i));
                childRequest.setFilter((Filter)filterList.get(i));
                childRequest.setReleaseAll(releaseAll);
                parentRequest.addSubRequest(childRequest);
            }
        } else if (filterSize == 0) {
            String message = "No filter found.  If you are sure you want to wipe out your database, then use a filter that is always true.  We just don't want you to inadvertantly wipe everything out without intending to";
            throw new WfsException(message);
        }
        return parentRequest;
    }
}

