/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geotools.feature.Feature;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterHandler;
import org.geotools.gml.GMLHandlerFeature;
import org.vfny.geoserver.wfs.WfsException;
import org.vfny.geoserver.wfs.requests.DeleteRequest;
import org.vfny.geoserver.wfs.requests.InsertRequest;
import org.vfny.geoserver.wfs.requests.State;
import org.vfny.geoserver.wfs.requests.SubTransactionRequest;
import org.vfny.geoserver.wfs.requests.TransactionRequest;
import org.vfny.geoserver.wfs.requests.UpdateRequest;
import org.vfny.geoserver.wfs.responses.WfsTransactionException;
import org.vfny.geoserver.wfs.servlets.WFService;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class TransactionHandler
extends XMLFilterImpl
implements ContentHandler,
FilterHandler,
GMLHandlerFeature {
    private static final State UNKNOWN = new State("UNKNOWN");
    private static final State INSERT = new State("Insert");
    private static final State DELETE = new State("Delete");
    private static final State UPDATE = new State("Update");
    private static final State PROPERTY_NAME = new State("Name");
    private static final State VALUE = new State("Value");
    private static final State PROPERTY = new State("Property");
    private static final State LOCKID = new State("LockId");
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.wfs");
    private TransactionRequest request = null;
    private SubTransactionRequest subRequest = null;
    private State state = UNKNOWN;
    private String curPropertyName;
    private Object curPropertyValue;
    private String curLockId = new String();
    private List curFeatures;
    private boolean inProperty = false;
    static /* synthetic */ Class class$org$vfny$geoserver$wfs$requests$InsertRequest;
    static /* synthetic */ Class class$org$vfny$geoserver$wfs$requests$UpdateRequest;

    public TransactionHandler(WFService service) {
        this.request = new TransactionRequest(service);
    }

    public TransactionRequest getRequest(HttpServletRequest req) {
        this.request.setHttpServletRequest(req);
        return this.request;
    }

    private static State toState(String stateName) {
        if (INSERT.isTag(stateName)) {
            return INSERT;
        }
        if (DELETE.isTag(stateName)) {
            return DELETE;
        }
        if (UPDATE.isTag(stateName)) {
            return UPDATE;
        }
        if (PROPERTY_NAME.isTag(stateName)) {
            return PROPERTY_NAME;
        }
        if (VALUE.isTag(stateName)) {
            return VALUE;
        }
        if (PROPERTY.isTag(stateName)) {
            return PROPERTY;
        }
        if (LOCKID.isTag(stateName)) {
            return LOCKID;
        }
        return UNKNOWN;
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        LOGGER.finest("at start element: " + localName);
        this.state = TransactionHandler.toState(localName);
        if (this.state == DELETE || this.state == UPDATE || this.state == INSERT) {
            if (this.state == DELETE) {
                this.subRequest = new DeleteRequest();
            } else if (this.state == UPDATE) {
                this.subRequest = new UpdateRequest();
            } else if (this.state == INSERT) {
                this.subRequest = new InsertRequest();
                this.curFeatures = new ArrayList();
            }
            int n = atts.getLength();
            for (int i = 0; i < n; ++i) {
                String name = atts.getLocalName(i);
                String value = atts.getValue(i);
                LOGGER.finest("found attribute '" + name + "'=" + value);
                if (name.equals("typeName")) {
                    this.subRequest.setTypeName(value);
                    continue;
                }
                if (!name.equals("handle")) continue;
                this.subRequest.setHandle(value);
            }
        } else if (localName.equals("Transaction")) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (atts.getLocalName(i).equals("handle")) {
                    LOGGER.finest("found handle: " + atts.getValue(i));
                    this.request.setHandle(atts.getValue(i));
                    continue;
                }
                if (atts.getLocalName(i).equals("releaseAction")) {
                    LOGGER.finest("found releaseAction: " + atts.getValue(i));
                    try {
                        this.request.setReleaseAction(atts.getValue(i));
                        continue;
                    }
                    catch (WfsTransactionException e) {
                        throw new SAXException((Exception)((Object)e));
                    }
                }
                if (!atts.getLocalName(i).equals("LockId")) continue;
                LOGGER.finest("found LockId: " + atts.getValue(i));
                this.request.setLockId(atts.getValue(i));
            }
        } else if (this.state == PROPERTY) {
            this.inProperty = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        LOGGER.finer("at end element: " + localName);
        this.state = TransactionHandler.toState(localName);
        if (this.state == DELETE || this.state == UPDATE || this.state == INSERT) {
            if (this.subRequest.getClass().equals(class$org$vfny$geoserver$wfs$requests$InsertRequest == null ? (class$org$vfny$geoserver$wfs$requests$InsertRequest = TransactionHandler.class$("org.vfny.geoserver.wfs.requests.InsertRequest")) : class$org$vfny$geoserver$wfs$requests$InsertRequest)) {
                try {
                    ((InsertRequest)this.subRequest).addFeatures(this.curFeatures.toArray(new Feature[0]));
                }
                catch (WfsException we) {
                    throw new SAXException("Problem adding features: " + ((Throwable)((Object)we)).getMessage(), (Exception)((Object)we));
                }
                this.curFeatures = new ArrayList();
            }
            this.request.addSubRequest(this.subRequest);
        } else if (this.state == PROPERTY) {
            LOGGER.finer("ending property");
            if (!this.subRequest.getClass().equals(class$org$vfny$geoserver$wfs$requests$UpdateRequest == null ? (class$org$vfny$geoserver$wfs$requests$UpdateRequest = TransactionHandler.class$("org.vfny.geoserver.wfs.requests.UpdateRequest")) : class$org$vfny$geoserver$wfs$requests$UpdateRequest)) throw new SAXException("<property> element should only occur within a <update> element.");
            ((UpdateRequest)this.subRequest).addProperty(this.curPropertyName, this.curPropertyValue);
            LOGGER.finer("setting update property " + this.curPropertyName + " to " + this.curPropertyValue);
            this.curPropertyName = new String();
            this.curPropertyValue = null;
            this.inProperty = false;
        } else if (this.state == LOCKID) {
            this.request.setLockId(this.curLockId);
            this.curLockId = new String();
        }
        this.state = UNKNOWN;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.state == PROPERTY_NAME) {
            String s = new String(ch, start, length);
            LOGGER.finest("found property name: " + s);
            this.curPropertyName = s.trim();
        } else if (this.state == VALUE) {
            String s = new String(ch, start, length);
            if (this.curPropertyValue != null && !(this.curPropertyValue instanceof String)) {
                if (!"".equals(s.trim())) {
                    this.curPropertyValue = this.curPropertyValue + s;
                }
            } else {
                this.curPropertyValue = this.curPropertyValue == null ? s : this.curPropertyValue + s;
            }
        } else if (this.state == LOCKID) {
            String s = new String(ch, start, length);
            this.curLockId = s.trim();
        }
    }

    public void filter(Filter filter) throws RuntimeException {
        try {
            this.subRequest.setFilter(filter);
        }
        catch (WfsException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public void feature(Feature feature) {
        this.curFeatures.add(feature);
        LOGGER.finest("feature added: " + feature);
    }

    public void geometry(Geometry geometry) {
        LOGGER.finer("recieved geometry " + geometry);
        if (this.inProperty) {
            this.curPropertyValue = geometry;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

