/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.vfny.geoserver.wfs.Query;
import org.vfny.geoserver.wfs.requests.WFSRequest;
import org.vfny.geoserver.wfs.servlets.WFService;

public class FeatureRequest
extends WFSRequest {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests");
    protected int maxFeatures = Integer.MAX_VALUE;
    protected String outputFormat = "GML2";
    protected String handle = null;
    protected String featureVersion = null;
    protected List queries = new ArrayList();

    public FeatureRequest(WFService service) {
        super("GetFeature", service);
    }

    public void setQueries(List queries) {
        this.queries = queries;
    }

    public void addQuery(Query query) {
        this.queries.add(query);
    }

    public List getQueries() {
        return this.queries;
    }

    public int getQueryCount() {
        return this.queries.size();
    }

    public Query getQuery(int i) {
        return (Query)this.queries.get(i);
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setFeatureVersion(String version) {
        this.version = version;
    }

    public String getFeatureVersion() {
        return this.version;
    }

    public void setMaxFeatures(int maxFeatures) {
        if (maxFeatures > 0) {
            this.maxFeatures = maxFeatures;
        }
    }

    public void setMaxFeatures(String maxFeatures) {
        if (maxFeatures != null) {
            Integer tempInt = new Integer(maxFeatures);
            this.setMaxFeatures(tempInt);
        }
    }

    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    public String toString() {
        StringBuffer returnString = new StringBuffer("\nRequest");
        returnString.append(": " + this.handle);
        returnString.append("\n output format:" + this.outputFormat);
        returnString.append("\n max features:" + this.maxFeatures);
        returnString.append("\n version:" + this.version);
        returnString.append("\n queries: ");
        ListIterator iterator = this.queries.listIterator();
        while (iterator.hasNext()) {
            returnString.append(iterator.next().toString() + " \n");
        }
        return returnString.toString();
    }

    public boolean equals(Object obj) {
        super.equals(obj);
        if (!(obj instanceof FeatureRequest)) {
            return false;
        }
        FeatureRequest frequest = (FeatureRequest)((Object)obj);
        boolean isEqual = true;
        isEqual = this.version == null && frequest.getVersion() == null ? isEqual : (this.version == null || frequest.getVersion() == null ? false : (frequest.getVersion().equals(this.version) ? isEqual : false));
        LOGGER.finest("checking version equality: " + isEqual);
        isEqual = this.handle == null && frequest.getHandle() == null ? isEqual : (this.handle == null || frequest.getHandle() == null ? false : (frequest.getHandle().equals(this.handle) ? isEqual : false));
        LOGGER.finest("checking handle equality: " + isEqual);
        isEqual = this.outputFormat == null && frequest.getOutputFormat() == null ? isEqual : (this.outputFormat == null || frequest.getOutputFormat() == null ? false : (frequest.getOutputFormat().equals(this.outputFormat) ? isEqual : false));
        LOGGER.finest("checking output format equality: " + isEqual);
        if (this.maxFeatures == frequest.getMaxFeatures()) {
            isEqual = isEqual;
        }
        LOGGER.finest("checking max features equality: " + isEqual);
        ListIterator internalIterator = this.queries.listIterator();
        ListIterator externalIterator = frequest.getQueries().listIterator();
        while (internalIterator.hasNext()) {
            if (!externalIterator.hasNext()) {
                isEqual = false;
                LOGGER.finest("query lists not same size");
                break;
            }
            if (((Query)internalIterator.next()).equals((Query)externalIterator.next())) {
                LOGGER.finest("query properties match: " + isEqual);
                continue;
            }
            isEqual = false;
            LOGGER.finest("queries not equal");
            break;
        }
        return isEqual;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 23 * result + (this.queries == null ? 0 : ((Object)this.queries).hashCode());
        result = 23 * result + (this.handle == null ? 0 : this.handle.hashCode());
        return result;
    }
}

