/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterHandler;
import org.vfny.geoserver.wfs.Query;
import org.vfny.geoserver.wfs.requests.FeatureRequest;
import org.vfny.geoserver.wfs.requests.FeatureWithLockRequest;
import org.vfny.geoserver.wfs.servlets.WFService;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class FeatureHandler
extends XMLFilterImpl
implements ContentHandler,
FilterHandler {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.wfs");
    private WFService service;
    private FeatureRequest request = null;
    private String insideTag = new String();
    private boolean insideQuery = false;
    private Query currentQuery = new Query();

    public FeatureHandler(WFService service) {
        this.service = service;
        this.request = new FeatureRequest(service);
    }

    public FeatureRequest getRequest(HttpServletRequest req) {
        this.request.setHttpServletRequest(req);
        return this.request;
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        block8: {
            block7: {
                LOGGER.finest("at start element: " + localName);
                this.insideTag = localName;
                if (!this.insideTag.equals("Query")) break block7;
                this.currentQuery = new Query();
                this.insideQuery = true;
                int n = atts.getLength();
                for (int i = 0; i < n; ++i) {
                    String name = atts.getLocalName(i);
                    String value = atts.getValue(i);
                    LOGGER.finest("found attribute '" + name + "'=" + value);
                    if (name.equals("typeName")) {
                        this.currentQuery.setTypeName(value);
                        continue;
                    }
                    if (!name.equals("handle")) continue;
                    this.currentQuery.setHandle(value);
                }
                break block8;
            }
            if (!this.insideTag.startsWith("GetFeature")) break block8;
            this.request = this.insideTag.equals("GetFeatureWithLock") ? new FeatureWithLockRequest(this.service) : new FeatureRequest(this.service);
            for (int i = 0; i < atts.getLength(); ++i) {
                String curAtt = atts.getLocalName(i);
                if (curAtt.equals("maxFeatures")) {
                    LOGGER.finest("found max features: " + atts.getValue(i));
                    this.request.setMaxFeatures(atts.getValue(i));
                    continue;
                }
                if (curAtt.equals("outputFormat")) {
                    LOGGER.finest("found outputFormat: " + atts.getValue(i));
                    this.request.setOutputFormat(atts.getValue(i));
                    continue;
                }
                if (!curAtt.equals("expiry") || !(this.request instanceof FeatureWithLockRequest)) continue;
                int expiry = -1;
                try {
                    expiry = Integer.parseInt(atts.getValue(i));
                }
                catch (NumberFormatException e) {
                    throw new SAXException("expiry should parse to an integer", e);
                }
                ((FeatureWithLockRequest)this.request).setExpiry(expiry);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        LOGGER.finer("at end element: " + localName);
        this.insideTag = "NULL";
        if (localName.equals("Query")) {
            LOGGER.finest("adding query: " + this.currentQuery.toString());
            this.insideQuery = false;
            this.request.addQuery(this.currentQuery);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (this.insideTag.equals("PropertyName")) {
            LOGGER.finest("found property name: " + s);
            this.currentQuery.addPropertyName(s);
        }
    }

    public void filter(Filter filter) {
        LOGGER.finest("found filter: " + filter.toString());
        if (this.insideQuery) {
            LOGGER.finest("add filter " + filter + " to query: " + this.currentQuery);
            this.currentQuery.addFilter(filter);
        } else {
            LOGGER.finest("adding filter to all queries: " + filter);
            int n = this.request.queries.size();
            for (int i = 0; i < n; ++i) {
                Query query = (Query)this.request.queries.get(i);
                Filter queryFilter = query.getFilter();
                if (queryFilter != null) {
                    query.addFilter(queryFilter.and(filter));
                    continue;
                }
                query.addFilter(filter);
            }
        }
    }
}

