/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.wfs.requests.DescribeRequest;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class DescribeHandler
extends XMLFilterImpl
implements ContentHandler {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.wfs");
    private DescribeRequest request = null;
    private String currentTag = new String();

    public DescribeHandler(DescribeRequest request) {
        this.request = request;
    }

    public DescribeRequest getRequest(HttpServletRequest req) {
        this.request.setHttpServletRequest(req);
        return this.request;
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        LOGGER.finest("found start element: " + localName);
        this.currentTag = localName;
        if (this.currentTag.equals("DescribeFeatureType")) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getLocalName(i).equals("outputFormat")) continue;
                LOGGER.finest("found outputFormat: " + atts.getValue(i));
                this.request.setOutputFormat(atts.getValue(i));
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        LOGGER.finest("found end element: " + localName);
        this.currentTag = "";
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (this.currentTag.equals("TypeName")) {
            this.request.addFeatureType(s);
            LOGGER.finest("added type name: " + s);
        }
    }
}

