/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import org.vfny.geoserver.config.ServiceConfig;
import org.vfny.geoserver.global.WFS;
import org.vfny.geoserver.global.dto.WFSDTO;

public class WFSConfig
extends ServiceConfig {
    public static final String CONFIG_KEY = "Config.WFS";
    private int serviceLevel;
    private boolean citeConformanceHacks = false;
    private boolean featureBounding = false;
    private boolean srsXmlStyle = true;

    public WFSConfig() {
        this.srsXmlStyle = true;
    }

    public WFSConfig(WFSDTO w) {
        super(w.getService());
        this.serviceLevel = w.getServiceLevel();
        this.srsXmlStyle = w.isSrsXmlStyle();
        this.citeConformanceHacks = w.getCiteConformanceHacks();
        this.featureBounding = w.isFeatureBounding();
    }

    public WFSConfig(WFS wfs) {
        this((WFSDTO)wfs.toDTO());
    }

    public void update(WFSDTO dto) {
        if (dto == null) {
            throw new NullPointerException("WFS Data Transfer Object required");
        }
        super.update(dto.getService());
        this.srsXmlStyle = dto.isSrsXmlStyle();
        this.serviceLevel = dto.getServiceLevel();
        this.citeConformanceHacks = dto.getCiteConformanceHacks();
        this.featureBounding = dto.isFeatureBounding();
    }

    public WFSDTO toDTO() {
        WFSDTO wfsDto = new WFSDTO();
        wfsDto.setService(super.toServDTO());
        wfsDto.setServiceLevel(this.serviceLevel);
        wfsDto.setSrsXmlStyle(this.srsXmlStyle);
        wfsDto.setCiteConformanceHacks(this.citeConformanceHacks);
        wfsDto.setFeatureBounding(this.featureBounding);
        return wfsDto;
    }

    public int getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(int serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public boolean isSrsXmlStyle() {
        return this.srsXmlStyle;
    }

    public void setSrsXmlStyle(boolean doXmlStyle) {
        this.srsXmlStyle = doXmlStyle;
    }

    public void setCiteConformanceHacks(boolean on) {
        this.citeConformanceHacks = on;
    }

    public boolean getCiteConformanceHacks() {
        return this.citeConformanceHacks;
    }

    public boolean isFeatureBounding() {
        return this.featureBounding;
    }

    public void setFeatureBounding(boolean featureBounding) {
        this.featureBounding = featureBounding;
    }
}

