/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.servlets;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.servlets.Dispatcher;
import org.vfny.geoserver.util.requests.EncodingInfo;
import org.vfny.geoserver.util.requests.XmlCharsetDetector;
import org.vfny.geoserver.util.requests.readers.DispatcherKvpReader;
import org.vfny.geoserver.util.requests.readers.DispatcherXmlReader;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wfs.WfsException;

public class WfsDispatcher
extends Dispatcher {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.servlets.wfs");
    private static int sequence = 123;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String ENCODING_HEADER_ARG = "Content-Type";
    private static final Pattern ENCODING_PATTERN = Pattern.compile("encoding\\s*\\=\\s*\"([^\"]+)\"");

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int targetRequest = 0;
        try {
            BufferedReader requestReader;
            BufferedReader disReader;
            int c;
            File temp;
            BufferedInputStream is = new BufferedInputStream((InputStream)request.getInputStream());
            ++sequence;
            try {
                temp = File.createTempFile("wfsdispatch" + sequence, "tmp");
                if (!temp.canRead() || !temp.canWrite()) {
                    String errorMsg = "Temporary-file permission problem for location: " + temp.getPath();
                    throw new IOException(errorMsg);
                }
            }
            catch (IOException e) {
                String errorMsg = "Possible file permission problem. Root cause: \n" + e.toString();
                IOException newE = new IOException(errorMsg);
                throw newE;
            }
            temp.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(temp);
            BufferedOutputStream out = new BufferedOutputStream(fos);
            while (-1 != (c = ((InputStream)is).read())) {
                out.write(c);
            }
            ((InputStream)is).close();
            out.flush();
            out.close();
            EncodingInfo encInfo = new EncodingInfo();
            try {
                disReader = new BufferedReader(XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(temp), (EncodingInfo)encInfo));
                requestReader = new BufferedReader(XmlCharsetDetector.createReader((InputStream)new FileInputStream(temp), (EncodingInfo)encInfo));
            }
            catch (Exception e) {
                throw new WfsException(e);
            }
            if (disReader != null) {
                DispatcherXmlReader requestTypeAnalyzer = new DispatcherXmlReader();
                try {
                    requestTypeAnalyzer.read((Reader)disReader, request);
                }
                catch (ServiceException e) {
                    throw new WfsException(e);
                }
            } else {
                targetRequest = -1;
            }
            LOGGER.fine("post got request " + targetRequest);
            this.doResponse(requestReader, request, response, targetRequest);
        }
        catch (WfsException wfs) {
            HttpSession session = request.getSession();
            ServletContext context = session.getServletContext();
            GeoServer geoServer = (GeoServer)context.getAttribute("GeoServer");
            String tempResponse = wfs.getXmlResponse(geoServer.isVerboseExceptions(), request, geoServer);
            response.setContentType(geoServer.getCharSet().toString());
            response.getWriter().write(tempResponse);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int targetRequest = 0;
        if (request.getQueryString() != null) {
            Map kvPairs = KvpRequestReader.parseKvpSet((String)request.getQueryString());
            targetRequest = DispatcherKvpReader.getRequestType((Map)kvPairs);
        } else {
            targetRequest = -1;
        }
        this.doResponse(null, request, response, targetRequest);
    }

    protected void doResponse(Reader requestReader, HttpServletRequest request, HttpServletResponse response, int req_type) throws ServletException, IOException {
        LOGGER.info("req_type is " + req_type);
    }
}

