/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.responses;

import com.vividsolutions.jts.geom.Envelope;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.validation.Validation;
import org.geotools.validation.ValidationProcessor;
import org.geotools.validation.ValidationResults;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wfs.WfsException;
import org.vfny.geoserver.wfs.requests.DeleteRequest;
import org.vfny.geoserver.wfs.requests.InsertRequest;
import org.vfny.geoserver.wfs.requests.SubTransactionRequest;
import org.vfny.geoserver.wfs.requests.TransactionRequest;
import org.vfny.geoserver.wfs.requests.UpdateRequest;
import org.vfny.geoserver.wfs.requests.WFSRequest;
import org.vfny.geoserver.wfs.responses.WfsTransResponse;
import org.vfny.geoserver.wfs.responses.WfsTransactionException;

public class TransactionResponse
implements Response {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses");
    private WfsTransResponse response;
    private TransactionRequest request;
    protected Transaction transaction = null;

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request req) throws ServiceException, WfsException {
        WFSRequest request = (WFSRequest)req;
        if (!(request instanceof TransactionRequest)) {
            throw new WfsException("bad request, expected TransactionRequest, but got " + (Object)((Object)request));
        }
        if ((request.getWFS().getServiceLevel() & 0xF) == 0) {
            throw new ServiceException("Transaction support is not enabled");
        }
        this.execute((TransactionRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute(TransactionRequest transactionRequest) throws ServiceException, WfsException {
        FeatureStore store;
        this.request = transactionRequest;
        this.transaction = new DefaultTransaction();
        LOGGER.fine("request is " + (Object)((Object)this.request));
        Data catalog = transactionRequest.getWFS().getData();
        WfsTransResponse build = new WfsTransResponse(0, transactionRequest.getGeoServer().isVerbose());
        HashMap<String, FeatureSource> stores = new HashMap<String, FeatureSource>();
        HashMap<String, FeatureSource> stores2 = new HashMap<String, FeatureSource>();
        for (int i = 0; i < this.request.getSubRequestSize(); ++i) {
            FeatureTypeInfo meta;
            String elementName;
            String typeRef;
            SubTransactionRequest element;
            block49: {
                element = this.request.getSubRequest(i);
                typeRef = null;
                elementName = null;
                meta = null;
                if (element instanceof InsertRequest) {
                    Feature feature = ((InsertRequest)element).getFeatures().features().next();
                    if (feature != null) {
                        String name = feature.getFeatureType().getTypeName();
                        URI uri = feature.getFeatureType().getNamespace();
                        LOGGER.fine("Locating FeatureSource uri:'" + uri + "' name:'" + name + "'");
                        meta = catalog.getFeatureTypeInfo(name, uri == null ? null : uri.toString());
                        element.setTypeName(meta.getNameSpace().getPrefix() + ":" + meta.getTypeName());
                        break block49;
                    } else {
                        LOGGER.finer("Insert was empty - does not need a FeatuerSoruce");
                        continue;
                    }
                }
                typeRef = null;
                elementName = element.getTypeName();
                if (stores.containsKey(elementName)) {
                    LOGGER.finer("FeatureSource '" + elementName + "' already loaded.");
                    continue;
                }
                LOGGER.fine("Locating FeatureSource '" + elementName + "'...");
                meta = catalog.getFeatureTypeInfo(elementName);
                element.setTypeName(meta.getNameSpace().getPrefix() + ":" + meta.getTypeName());
            }
            typeRef = meta.getDataStoreInfo().getId() + ":" + meta.getTypeName();
            elementName = meta.getNameSpace().getPrefix() + ":" + meta.getTypeName();
            LOGGER.fine("located FeatureType w/ typeRef '" + typeRef + "' and elementName '" + elementName + "'");
            if (stores.containsKey(elementName)) continue;
            try {
                FeatureSource source = meta.getFeatureSource();
                if (!(source instanceof FeatureStore)) {
                    throw new WfsTransactionException(elementName + " is read-only", element.getHandle(), this.request.getHandle());
                }
                store = (FeatureStore)source;
                store.setTransaction(this.transaction);
                stores.put(elementName, source);
                stores2.put(typeRef, source);
                continue;
            }
            catch (IOException ioException) {
                throw new WfsTransactionException(elementName + " is not available:" + ioException, element.getHandle(), this.request.getHandle());
            }
        }
        String authorizationID = this.request.getLockId();
        if (authorizationID != null) {
            if ((this.request.getWFS().getServiceLevel() & 0x10) == 0) {
                throw new ServiceException("Lock support is not enabled");
            }
            LOGGER.finer("got lockId: " + authorizationID);
            if (!catalog.lockExists(authorizationID)) {
                String mesg = "Attempting to use a lockID that does not exist, it has either expired or was entered wrong.";
                throw new WfsException(mesg);
            }
            try {
                this.transaction.addAuthorization(authorizationID);
            }
            catch (IOException ioException) {
                throw new WfsException("Authorization ID '" + authorizationID + "' not useable", ioException);
            }
        }
        Envelope envelope = new Envelope();
        for (int i = 0; i < this.request.getSubRequestSize(); ++i) {
            Set<String> fids;
            Filter filter;
            SubTransactionRequest element = this.request.getSubRequest(i);
            String elementName = element.getTypeName();
            String handle = element.getHandle();
            store = (FeatureStore)stores.get(elementName);
            if (store == null) {
                throw new ServiceException("Could not locate FeatureStore for '" + elementName + "'");
            }
            String typeName = store.getSchema().getTypeName();
            if (element instanceof DeleteRequest) {
                if ((this.request.getWFS().getServiceLevel() & 8) == 0) {
                    throw new ServiceException("Transaction Delete support is not enabled");
                }
                DeleteRequest delete = (DeleteRequest)element;
                if (delete.getFilter() == Filter.NONE) {
                    throw new ServiceException("Filter must be supplied for Transaction Delete");
                }
                LOGGER.finer("Transaction Delete:" + element);
                try {
                    filter = delete.getFilter();
                    Envelope damaged = store.getBounds((Query)new DefaultQuery(delete.getTypeName(), filter));
                    if (damaged == null) {
                        damaged = store.getFeatures(filter).getBounds();
                    }
                    if (this.request.getLockId() != null && store instanceof FeatureLocking && this.request.getReleaseAction() == TransactionRequest.SOME) {
                        FeatureLocking locking = (FeatureLocking)store;
                        DataStore data = store.getDataStore();
                        FilterFactory factory = FilterFactoryFinder.createFilterFactory();
                        FeatureWriter writer = data.getFeatureWriter(typeName, filter, this.transaction);
                        try {
                            while (writer.hasNext()) {
                                String fid = writer.next().getID();
                                locking.unLockFeatures((Filter)factory.createFidFilter(fid));
                                writer.remove();
                            }
                        }
                        finally {
                            writer.close();
                        }
                        store.removeFeatures(filter);
                    } else {
                        store.removeFeatures(filter);
                    }
                    envelope.expandToInclude(damaged);
                }
                catch (IOException ioException) {
                    throw new WfsTransactionException(ioException.getMessage(), element.getHandle(), this.request.getHandle());
                }
            }
            if (element instanceof InsertRequest) {
                if ((this.request.getWFS().getServiceLevel() & 2) == 0) {
                    throw new ServiceException("Transaction INSERT support is not enabled");
                }
                LOGGER.finer("Transasction Insert:" + element);
                try {
                    InsertRequest insert = (InsertRequest)element;
                    FeatureCollection collection = insert.getFeatures();
                    FeatureReader reader = DataUtilities.reader((Collection)collection);
                    FeatureType schema = store.getSchema();
                    FeatureTypeInfo typeInfo = catalog.getFeatureTypeInfo(element.getTypeName());
                    LOGGER.finer("Use featureValidation to check contents of insert");
                    this.featureValidation(typeInfo.getDataStoreInfo().getId(), schema, collection);
                    fids = store.addFeatures(reader);
                    build.addInsertResult(element.getHandle(), fids);
                    envelope.expandToInclude(collection.getBounds());
                }
                catch (IOException ioException) {
                    throw new WfsTransactionException(ioException, element.getHandle(), this.request.getHandle());
                }
            }
            if (!(element instanceof UpdateRequest)) continue;
            if ((this.request.getWFS().getServiceLevel() & 4) == 0) {
                throw new ServiceException("Transaction Update support is not enabled");
            }
            LOGGER.finer("Transaction Update:" + element);
            try {
                UpdateRequest update = (UpdateRequest)element;
                filter = update.getFilter();
                AttributeType[] types = update.getTypes(store.getSchema());
                Object[] values = update.getValues();
                DefaultQuery query = new DefaultQuery(update.getTypeName(), filter);
                fids = new HashSet();
                LOGGER.finer("Preprocess to remember modification as a set of fids");
                FeatureReader preprocess = store.getFeatures(filter).reader();
                try {
                    while (preprocess.hasNext()) {
                        Feature feature = preprocess.next();
                        fids.add(feature.getID());
                        envelope.expandToInclude(feature.getBounds());
                    }
                }
                catch (NoSuchElementException e) {
                    throw new ServiceException("Could not aquire FeatureIDs", (Throwable)e);
                }
                catch (IllegalAttributeException e) {
                    throw new ServiceException("Could not aquire FeatureIDs", (Throwable)e);
                }
                finally {
                    preprocess.close();
                }
                try {
                    if (types.length == 1) {
                        store.modifyFeatures(types[0], values[0], filter);
                    } else {
                        store.modifyFeatures(types, values, filter);
                    }
                }
                catch (IOException e) {
                    build = new WfsTransResponse(1, transactionRequest.getGeoServer().isVerbose());
                    build.setMessage(e.getLocalizedMessage());
                    this.response = build;
                    return;
                }
                if (this.request.getLockId() != null && store instanceof FeatureLocking && this.request.getReleaseAction() == TransactionRequest.SOME) {
                    FeatureLocking locking = (FeatureLocking)store;
                    locking.unLockFeatures(filter);
                }
                if (fids.isEmpty()) continue;
                LOGGER.finer("Post process update for boundary update and featureValidation");
                FidFilter modified = FilterFactoryFinder.createFilterFactory().createFidFilter();
                modified.addAllFids(fids);
                FeatureCollection changed = store.getFeatures((Filter)modified).collection();
                envelope.expandToInclude(changed.getBounds());
                FeatureTypeInfo typeInfo = catalog.getFeatureTypeInfo(element.getTypeName());
                this.featureValidation(typeInfo.getDataStoreInfo().getId(), store.getSchema(), changed);
                continue;
            }
            catch (IOException ioException) {
                throw new WfsTransactionException(ioException, element.getHandle(), this.request.getHandle());
            }
            catch (SchemaException typeException) {
                throw new WfsTransactionException(typeName + " inconsistent with update:" + typeException.getMessage(), element.getHandle(), this.request.getHandle());
            }
        }
        try {
            this.integrityValidation(stores2, envelope);
        }
        catch (Exception invalid) {
            throw new WfsTransactionException(invalid);
        }
        this.response = build;
    }

    protected void featureValidation(String dsid, FeatureType type, FeatureCollection collection) throws IOException, WfsTransactionException {
        LOGGER.finer("FeatureValidation called on " + dsid + ":" + type.getTypeName());
        ValidationProcessor validation = this.request.getValidationProcessor();
        if (validation == null) {
            LOGGER.warning("ValidationProcessor unavailable");
            return;
        }
        final TreeMap failed = new TreeMap();
        ValidationResults results = new ValidationResults(){
            String name;
            String description;

            public void setValidation(Validation validation) {
                this.name = validation.getName();
                this.description = validation.getDescription();
            }

            public void error(Feature feature, String message) {
                LOGGER.warning(this.name + ": " + message + " (" + this.description + ")");
                failed.put(feature.getID(), this.name + ": " + message + " " + "(" + this.description + ")");
            }

            public void warning(Feature feature, String message) {
                LOGGER.warning(this.name + ": " + message + " (" + this.description + ")");
            }
        };
        try {
            FeatureReader fr = DataUtilities.reader((Collection)collection);
            validation.runFeatureTests(dsid, type, fr, results);
        }
        catch (Exception badIdea) {
            throw new DataSourceException("Validation Failed", (Throwable)badIdea);
        }
        if (failed.isEmpty()) {
            return;
        }
        StringBuffer message = new StringBuffer();
        Iterator i = failed.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            message.append(entry.getKey());
            message.append(" failed test ");
            message.append(entry.getValue());
            message.append("\n");
        }
        throw new WfsTransactionException(message.toString(), "validation");
    }

    protected void integrityValidation(Map stores, Envelope check) throws IOException, WfsTransactionException {
        Data catalog = this.request.getWFS().getData();
        ValidationProcessor validation = this.request.getValidationProcessor();
        if (validation == null) {
            LOGGER.warning("Validation Processor unavaialble");
            return;
        }
        LOGGER.finer("Required to validate " + stores.size() + " typeRefs");
        LOGGER.finer("within " + check);
        HashSet<String> typeRefs = new HashSet<String>();
        Iterator i = stores.keySet().iterator();
        while (i.hasNext()) {
            String typeRef = (String)i.next();
            typeRefs.add(typeRef);
            Set dependencies = validation.getDependencies(typeRef);
            LOGGER.finer("typeRef " + typeRef + " requires " + dependencies);
            typeRefs.addAll(dependencies);
        }
        HashMap sources = new HashMap();
        Iterator i2 = typeRefs.iterator();
        while (i2.hasNext()) {
            String typeRef = (String)i2.next();
            LOGGER.finer("Searching for required typeRef: " + typeRef);
            if (stores.containsKey(typeRef)) {
                LOGGER.finer(" found required typeRef: " + typeRef + " (it was already loaded)");
                sources.put(typeRef, stores.get(typeRef));
                continue;
            }
            LOGGER.finer(" could not find typeRef: " + typeRef + " (we will now load it)");
            String[] split = typeRef.split(":");
            String dataStoreId = split[0];
            String typeName = split[1];
            LOGGER.finer(" going to look for dataStoreId:" + dataStoreId + " and typeName:" + typeName);
            String uri = catalog.getDataStoreInfo(dataStoreId).getNameSpace().getURI();
            LOGGER.finer(" sorry I mean uri: " + uri + " and typeName:" + typeName);
            FeatureTypeInfo meta = catalog.getFeatureTypeInfo(typeName, uri);
            if (meta == null) {
                throw new IOException("Could not find typeRef:" + typeRef + " for validation processor");
            }
            LOGGER.finer(" loaded required typeRef: " + typeRef);
            sources.put(typeRef, meta.getFeatureSource());
        }
        LOGGER.finer("Total of " + sources.size() + " featureSource marshalled for testing");
        final TreeMap failed = new TreeMap();
        ValidationResults results = new ValidationResults(){
            String name;
            String description;

            public void setValidation(Validation validation) {
                this.name = validation.getName();
                this.description = validation.getDescription();
            }

            public void error(Feature feature, String message) {
                LOGGER.warning(this.name + ": " + message + " (" + this.description + ")");
                if (feature == null) {
                    failed.put("ALL", this.name + ": " + message + " " + "(" + this.description + ")");
                } else {
                    failed.put(feature.getID(), this.name + ": " + message + " " + "(" + this.description + ")");
                }
            }

            public void warning(Feature feature, String message) {
                LOGGER.warning(this.name + ": " + message + " (" + this.description + ")");
            }
        };
        try {
            LOGGER.finer("Runing integrity tests using validation processor ");
            validation.runIntegrityTests(stores.keySet(), sources, check, results);
        }
        catch (Exception badIdea) {
            badIdea.printStackTrace();
            throw new DataSourceException("Validation Failed", (Throwable)badIdea);
        }
        if (failed.isEmpty()) {
            LOGGER.finer("All validation tests passed");
            return;
        }
        LOGGER.finer("Validation fail - marshal result for transaction document");
        StringBuffer message = new StringBuffer();
        Iterator i3 = failed.entrySet().iterator();
        while (i3.hasNext()) {
            Map.Entry entry = i3.next();
            message.append(entry.getKey());
            message.append(" failed test ");
            message.append(entry.getValue());
            message.append("\n");
        }
        throw new WfsTransactionException(message.toString(), "validation");
    }

    public String getContentType(GeoServer gs) {
        return gs.getMimeType();
    }

    public String getContentEncoding() {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void writeTo(OutputStream out) throws ServiceException, IOException {
        if (this.transaction == null || this.response == null) {
            throw new ServiceException("Transaction not executed");
        }
        if (this.response.status == 2) {
            throw new ServiceException("Canceling PARTIAL response");
        }
        try {
            writer = new OutputStreamWriter(out);
            writer = new BufferedWriter(writer);
            this.response.writeXmlResponse(writer, this.request);
            writer.flush();
            switch (this.response.status) {
                case 0: {
                    this.transaction.commit();
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                case 1: {
                    this.transaction.rollback();
                    break;
                }
                ** default:
lbl19:
                // 1 sources

                break;
            }
        }
        catch (IOException ioException) {
            this.transaction.rollback();
            throw ioException;
        }
        finally {
            this.transaction.close();
            this.transaction = null;
        }
        catalog = this.request.getWFS().getData();
        if (this.request.getLockId() != null) {
            if (this.request.getReleaseAction() == TransactionRequest.ALL) {
                catalog.lockRelease(this.request.getLockId());
            } else if (this.request.getReleaseAction() == TransactionRequest.SOME) {
                catalog.lockRefresh(this.request.getLockId());
            }
        }
    }

    public void abort(Service gs) {
        if (this.transaction == null) {
            return;
        }
        try {
            this.transaction.rollback();
            this.transaction.close();
        }
        catch (IOException ioException) {
            LOGGER.log(Level.SEVERE, "Failed trying to rollback a transaction:" + ioException);
        }
        if (this.request != null && this.request.getLockId() != null) {
            Data catalog = gs.getData();
            if (this.request.getReleaseAction() == TransactionRequest.ALL) {
                catalog.lockRelease(this.request.getLockId());
            } else if (this.request.getReleaseAction() == TransactionRequest.SOME) {
                catalog.lockRefresh(this.request.getLockId());
            }
        }
        this.request = null;
        this.response = null;
    }

    public String getContentDisposition() {
        return null;
    }
}

