/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.responses;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.geotools.feature.FeatureType;
import org.geotools.gml.producer.FeatureTypeTransformer;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.WFS;
import org.vfny.geoserver.wfs.WfsException;
import org.vfny.geoserver.wfs.requests.DescribeRequest;
import org.vfny.geoserver.wfs.requests.WFSRequest;

public class DescribeResponse
implements Response {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses");
    private static final String SCHEMA_URI = "\"http://www.w3.org/2001/XMLSchema\"";
    private static final String XS_NAMESPACE = "\n  xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"";
    private static final String GML_URL = "\"http://www.opengis.net/gml\"";
    private static final String GML_NAMESPACE = "\n  xmlns:gml=\"http://www.opengis.net/gml\"";
    private static final String ELEMENT_FORM_DEFAULT = "\n  elementFormDefault=\"qualified\"";
    private static final String ATTR_FORM_DEFAULT = "\n  attributeFormDefault=\"unqualified\" version=\"1.0\">";
    private static final String TARGETNS_PREFIX = "\n  targetNamespace=\"";
    private static final String TARGETNS_SUFFIX = "\" ";
    private static final String FOOTER = "\n</xs:schema>";
    private DescribeRequest request;
    private String xmlResponse = "";

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request req) throws WfsException {
        DescribeRequest wfsRequest;
        WFSRequest request = (WFSRequest)req;
        if (!(request instanceof DescribeRequest)) {
            throw new WfsException("illegal request type, expected DescribeRequest, got " + (Object)((Object)request));
        }
        this.request = wfsRequest = (DescribeRequest)request;
        LOGGER.finer("processing describe request" + (Object)((Object)wfsRequest));
        String outputFormat = wfsRequest.getOutputFormat();
        if (!outputFormat.equalsIgnoreCase("XMLSCHEMA")) {
            throw new WfsException("output format: " + outputFormat + " not " + "supported by geoserver");
        }
        this.xmlResponse = this.generateTypes(wfsRequest);
        if (!request.getWFS().getGeoServer().isVerbose()) {
            this.xmlResponse = this.xmlResponse.replaceAll(">\n[ \\t\\n]*", ">");
            this.xmlResponse = this.xmlResponse.replaceAll("\n[ \\t\\n]*", " ");
        }
    }

    public String getContentType(GeoServer gs) {
        return gs.getMimeType();
    }

    public String getContentEncoding() {
        return null;
    }

    public void writeTo(OutputStream out) throws WfsException {
        try {
            byte[] content = this.xmlResponse.getBytes();
            out.write(content);
        }
        catch (IOException ex) {
            throw new WfsException(ex, "", this.getClass().getName());
        }
    }

    private final String generateTypes(DescribeRequest wfsRequest) throws WfsException {
        ArrayList requestedTypes = wfsRequest.getFeatureTypes();
        StringBuffer tempResponse = new StringBuffer();
        if (requestedTypes.size() == 0) {
            requestedTypes = new ArrayList(wfsRequest.getWFS().getData().getFeatureTypeInfos().keySet());
        }
        tempResponse.append("<?xml version=\"1.0\" encoding=\"" + wfsRequest.getGeoServer().getCharSet().name() + "\"?>" + "\n<xs:schema ");
        if (this.allSameType(requestedTypes, wfsRequest)) {
            FeatureTypeInfo nsInfoType = wfsRequest.getWFS().getData().getFeatureTypeInfo((String)requestedTypes.get(0));
            NameSpaceInfo namespace = nsInfoType.getDataStoreInfo().getNameSpace();
            String targetNs = namespace.getUri();
            tempResponse.append(TARGETNS_PREFIX + targetNs + TARGETNS_SUFFIX);
            tempResponse.append("\n  xmlns:" + namespace.getPrefix() + "=\"" + targetNs + "\"");
            tempResponse.append(GML_NAMESPACE);
            tempResponse.append(XS_NAMESPACE);
            tempResponse.append("\n  elementFormDefault=\"qualified\"\n  attributeFormDefault=\"unqualified\" version=\"1.0\">");
            tempResponse.append("\n\n<xs:import namespace=\"http://www.opengis.net/gml\" schemaLocation=\"" + this.request.getSchemaBaseUrl() + "gml/2.1.2/feature.xsd\"/>\n\n");
            tempResponse.append(this.generateSpecifiedTypes(requestedTypes, wfsRequest.getWFS()));
        } else {
            tempResponse.append(XS_NAMESPACE);
            tempResponse.append("\n  elementFormDefault=\"qualified\"\n  attributeFormDefault=\"unqualified\" version=\"1.0\">");
            HashSet<String> prefixes = new HashSet<String>();
            Iterator nameIter = requestedTypes.iterator();
            while (nameIter.hasNext()) {
                String typeName = nameIter.next().toString();
                String typePrefix = wfsRequest.getWFS().getData().getFeatureTypeInfo(typeName).getPrefix();
                prefixes.add(typePrefix);
            }
            Iterator prefixIter = prefixes.iterator();
            while (prefixIter.hasNext()) {
                String prefix = prefixIter.next().toString();
                tempResponse.append(this.getNSImport(prefix, requestedTypes, wfsRequest));
            }
        }
        tempResponse.append(FOOTER);
        return tempResponse.toString();
    }

    private StringBuffer getNSImport(String prefix, List typeNames, WFSRequest r) {
        LOGGER.finer("prefix is " + prefix);
        StringBuffer retBuffer = new StringBuffer("\n  <xs:import namespace=\"");
        String namespace = r.getWFS().getData().getNameSpace(prefix).getUri();
        retBuffer.append(namespace + "\"");
        retBuffer.append("\n        schemaLocation=\"" + r.getBaseUrl() + "wfs/DescribeFeatureType?typeName=");
        Iterator nameIter = typeNames.iterator();
        while (nameIter.hasNext()) {
            String typeName = nameIter.next().toString();
            if (!typeName.startsWith(prefix) && (typeName.indexOf(58) != -1 || !prefix.equals(r.getWFS().getData().getDefaultNameSpace().getPrefix()))) continue;
            retBuffer.append(typeName + ",");
        }
        retBuffer.deleteCharAt(retBuffer.length() - 1);
        retBuffer.append("\"/>");
        return retBuffer;
    }

    private String generateSpecifiedTypes(List requestedTypes, WFS gs) throws WfsException {
        String tempResponse = "";
        String currentFile = "";
        String curTypeName = "";
        String generatedType = "";
        HashSet<FeatureTypeInfo> validTypes = new HashSet<FeatureTypeInfo>();
        for (int i = 0; i < requestedTypes.size(); ++i) {
            curTypeName = requestedTypes.get(i).toString();
            FeatureTypeInfo meta = gs.getData().getFeatureTypeInfo(curTypeName);
            if (meta == null) {
                throw new WfsException("Feature Type " + curTypeName + " does " + "not exist on this server");
            }
            if (validTypes.contains(meta)) continue;
            File schemaFile = meta.getSchemaFile();
            try {
                if (schemaFile != null && schemaFile.exists() && schemaFile.canRead()) {
                    generatedType = this.writeFile(schemaFile);
                } else {
                    FeatureType ft2 = meta.getFeatureType();
                    String gType2 = this.generateFromSchema(ft2);
                    if (gType2 != null && gType2 != "") {
                        generatedType = gType2;
                    }
                }
            }
            catch (IOException e) {
                generatedType = "";
            }
            if (generatedType.equals("")) continue;
            tempResponse = tempResponse + generatedType;
            validTypes.add(meta);
        }
        Iterator i = validTypes.iterator();
        while (i.hasNext()) {
            tempResponse = tempResponse + DescribeResponse.printElement((FeatureTypeInfo)i.next());
        }
        tempResponse = tempResponse + "\n\n";
        return tempResponse;
    }

    private String generateFromSchema(FeatureType schema) throws WfsException {
        try {
            StringWriter writer = new StringWriter();
            FeatureTypeTransformer t = new FeatureTypeTransformer();
            t.setIndentation(4);
            t.setOmitXMLDeclaration(true);
            t.transform((Object)schema, (Writer)writer);
            return writer.getBuffer().toString();
        }
        catch (TransformerException te) {
            LOGGER.warning(te.toString());
            throw new WfsException("problem transforming type", te);
        }
    }

    private static String printElement(FeatureTypeInfo type) {
        return "\n  <xs:element name='" + type.getTypeName() + "' type='" + type.getPrefix() + ":" + type.getSchemaName() + "' substitutionGroup='gml:_Feature'/>";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String writeFile(File inputFile) throws WfsException {
        LOGGER.finest("writing file " + inputFile);
        String finalOutput = "";
        FileInputStream inputStream = null;
        try {
            try {
                int bytesRead;
                inputStream = new FileInputStream(inputFile);
                byte[] fileBuffer = new byte[inputStream.available()];
                while ((bytesRead = inputStream.read(fileBuffer)) != -1) {
                    String tempOutput = new String(fileBuffer);
                    finalOutput = finalOutput + tempOutput;
                }
                Object var8_8 = null;
                if (inputStream == null) return finalOutput;
            }
            catch (IOException e) {
                throw new WfsException("problem writing featureType information  from " + inputFile);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        inputStream.close();
        return finalOutput;
    }

    public boolean allSameType(Collection featureTypeNames, WFSRequest request) throws WfsException {
        Iterator nameIter = featureTypeNames.iterator();
        boolean sameType = true;
        if (!nameIter.hasNext()) {
            return false;
        }
        String firstPrefix = this.getPrefix(nameIter.next().toString(), request.getWFS());
        while (nameIter.hasNext()) {
            if (firstPrefix.equals(this.getPrefix(nameIter.next().toString(), request.getWFS()))) continue;
            return false;
        }
        return sameType;
    }

    private String getPrefix(String featureTypeName, WFS gs) throws WfsException {
        FeatureTypeInfo ftConf = gs.getData().getFeatureTypeInfo(featureTypeName);
        if (ftConf == null) {
            throw new WfsException("Feature Type " + featureTypeName + " does " + "not exist or is not enabled on this server");
        }
        return ftConf.getPrefix();
    }

    public void abort(Service gs) {
    }

    public String getContentDisposition() {
        return null;
    }
}

