/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests.readers;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wfs.WfsException;
import org.vfny.geoserver.wfs.requests.LockRequest;
import org.vfny.geoserver.wfs.requests.WfsKvpRequestReader;
import org.vfny.geoserver.wfs.servlets.WFService;

public class LockKvpReader
extends WfsKvpRequestReader {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.readers");

    public LockKvpReader(Map kvPairs, WFService service) {
        super(kvPairs, service);
    }

    public Request getRequest(HttpServletRequest request) throws ServiceException {
        LockRequest currentRequest = new LockRequest((WFService)this.service);
        currentRequest.setHttpServletRequest(request);
        LOGGER.finest("setting global request parameters");
        if (this.keyExists("VERSION")) {
            currentRequest.setVersion(this.getValue("VERSION"));
        }
        if (this.keyExists("REQUEST")) {
            currentRequest.setRequest(this.getValue("REQUEST"));
        }
        if (this.keyExists("EXPIRY")) {
            currentRequest.setExpiry(Integer.parseInt(this.getValue("EXPIRY")));
        }
        if (this.keyExists("LOCKACTION")) {
            String lockAction = this.getValue("LOCKACTION");
            if (lockAction == null) {
                currentRequest.setLockAll(true);
            } else if (lockAction.toUpperCase().equals("ALL")) {
                currentRequest.setLockAll(true);
            } else if (lockAction.toUpperCase().equals("SOME")) {
                currentRequest.setLockAll(false);
            } else {
                throw new WfsException("Illegal lock action: " + lockAction);
            }
        }
        LOGGER.finer("setting query request parameters");
        List typeList = KvpRequestReader.readFlat((String)this.getValue("TYPENAME"), (String)",");
        LOGGER.finer("type list size: " + typeList.size());
        List filterList = WfsKvpRequestReader.readFilters(this.getValue("FEATUREID"), this.getValue("FILTER"), this.getValue("BBOX"));
        if (typeList.size() == 0 && (typeList = KvpRequestReader.getTypesFromFids((String)this.getValue("FEATUREID"))).size() == 0) {
            throw new WfsException("The typename element is mandatory if no FEATUREID is present");
        }
        int featureSize = typeList.size();
        int filterSize = filterList.size();
        if (filterSize != featureSize && filterSize > 0 || filterSize > 0 && featureSize == 0) {
            throw new WfsException("Filter size does not match feature types.  Filter size: " + filterSize + " Feature size: " + featureSize);
        }
        currentRequest.setLocks(typeList, filterList);
        return currentRequest;
    }
}

