/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpression;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.util.requests.readers.WfsXmlRequestReader;
import org.vfny.geoserver.wfs.WfsException;
import org.vfny.geoserver.wfs.servlets.WFService;

public abstract class WfsKvpRequestReader
extends KvpRequestReader {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.readers");

    public WfsKvpRequestReader(Map kvpPairs, WFService service) {
        super(kvpPairs, (AbstractService)service);
    }

    protected static List readFilters(String fid, String filter, String bbox) throws WfsException {
        List unparsed = new ArrayList();
        ArrayList<Object> filters = new ArrayList<Object>();
        if (fid != null && filter == null && bbox == null) {
            LOGGER.finest("reading fid filter: " + fid);
            unparsed = KvpRequestReader.readNested((String)fid);
            ListIterator i = unparsed.listIterator();
            while (i.hasNext()) {
                List ids = (List)i.next();
                ListIterator innerIterator = ids.listIterator();
                while (innerIterator.hasNext()) {
                    FidFilter fidFilter = KvpRequestReader.factory.createFidFilter();
                    fidFilter.addFid((String)innerIterator.next());
                    filters.add(fidFilter);
                    LOGGER.finest("added fid filter: " + fidFilter);
                }
            }
            return filters;
        }
        if (filter != null && fid == null && bbox == null) {
            LOGGER.finest("reading filter: " + filter);
            unparsed = KvpRequestReader.readFlat((String)filter, (String)"()");
            ListIterator i = unparsed.listIterator();
            while (i.hasNext()) {
                StringReader filterReader = new StringReader((String)i.next());
                filters.add(WfsXmlRequestReader.readFilter(filterReader));
            }
            return filters;
        }
        if (bbox != null && fid == null && filter == null) {
            LOGGER.finest("bbox filter: " + bbox);
            double[] rawCoords = new double[4];
            unparsed = KvpRequestReader.readFlat((String)bbox, (String)",");
            ListIterator i = unparsed.listIterator();
            if (unparsed.size() != 4) {
                throw new IllegalArgumentException("Requested bounding box contains wrongnumber of coordinates (should have 4): " + unparsed.size());
            }
            int j = 0;
            while (i.hasNext()) {
                try {
                    rawCoords[j] = Double.parseDouble((String)i.next());
                    ++j;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Bounding box coordinate " + j + " is not parsable:" + unparsed.get(j));
                }
            }
            try {
                GeometryFilter finalFilter = KvpRequestReader.factory.createGeometryFilter((short)7);
                Coordinate[] coords = new Coordinate[]{new Coordinate(rawCoords[0], rawCoords[1]), new Coordinate(rawCoords[0], rawCoords[3]), new Coordinate(rawCoords[2], rawCoords[3]), new Coordinate(rawCoords[2], rawCoords[1]), new Coordinate(rawCoords[0], rawCoords[1])};
                LinearRing outerShell = new LinearRing(coords, new PrecisionModel(), 0);
                Polygon polygon = new Polygon(outerShell, new PrecisionModel(), 0);
                LiteralExpression rightExpression = KvpRequestReader.factory.createLiteralExpression((Object)polygon);
                finalFilter.addRightGeometry((Expression)rightExpression);
                filters.add(finalFilter);
                return filters;
            }
            catch (IllegalFilterException e) {
                ((Throwable)((Object)new WfsException("Filter creation problem: "))).initCause(e);
            }
        } else {
            if (bbox == null && fid == null && filter == null) {
                return new ArrayList();
            }
            throw new WfsException("GetFeature KVP request contained conflicting filters.  Filter: " + filter + ", fid: " + fid + ", bbox:" + bbox);
        }
        return null;
    }
}

