/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import java.util.ArrayList;
import java.util.List;
import org.vfny.geoserver.wfs.requests.ReleaseAction;
import org.vfny.geoserver.wfs.requests.SubTransactionRequest;
import org.vfny.geoserver.wfs.requests.WFSRequest;
import org.vfny.geoserver.wfs.responses.WfsTransactionException;
import org.vfny.geoserver.wfs.servlets.WFService;

public class TransactionRequest
extends WFSRequest {
    public static final String TRANSACTION_REQUEST_TYPE = "Transaction";
    protected List subRequests = new ArrayList();
    protected String lockId = null;
    public static final ReleaseAction ALL = new ReleaseAction("ALL");
    public static final ReleaseAction SOME = new ReleaseAction("SOME");
    protected ReleaseAction releaseAction = ALL;
    protected String handle = null;

    public TransactionRequest(WFService service) {
        super(TRANSACTION_REQUEST_TYPE, service);
    }

    public void addSubRequest(SubTransactionRequest subRequest) {
        this.subRequests.add(subRequest);
        if (subRequest.getHandle() == null) {
            subRequest.setHandle(this.getHandle() + " " + subRequest.getTypeName() + " " + this.subRequests.size());
        }
    }

    public SubTransactionRequest getSubRequest(int i) {
        return (SubTransactionRequest)this.subRequests.get(i);
    }

    public int getSubRequestSize() {
        return this.subRequests.size();
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getHandle() {
        return this.handle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setReleaseAction(String releaseAction) throws WfsTransactionException {
        if (releaseAction != null) {
            if (releaseAction.toUpperCase().equals("ALL")) {
                this.releaseAction = ALL;
                return;
            } else {
                if (!releaseAction.toUpperCase().equals("SOME")) throw new WfsTransactionException("Illegal releaseAction: " + releaseAction + ", only " + "SOME or ALL allowed", this.handle, this.handle);
                this.releaseAction = SOME;
            }
            return;
        } else {
            this.releaseAction = ALL;
        }
    }

    public void setReleaseAction(boolean releaseAll) {
        this.releaseAction = releaseAll ? ALL : SOME;
    }

    public ReleaseAction getReleaseAction() {
        return this.releaseAction;
    }

    public void setLockId(String lockId) {
        this.lockId = lockId;
    }

    public String getLockId() {
        return this.lockId;
    }

    public String toString() {
        StringBuffer tRequest = new StringBuffer("Lock Id: " + this.lockId + "\n");
        tRequest.append("releaseAction: " + this.releaseAction + "\n");
        tRequest.append("handle: " + this.handle + "\n");
        for (int i = 0; i < this.subRequests.size(); ++i) {
            tRequest.append(this.subRequests.get(i).toString() + "\n");
        }
        return tRequest.toString();
    }

    private boolean testField(Object mine, Object test) {
        if (mine != null) {
            return mine.equals(test);
        }
        return test == null;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == ((Object)((Object)this)).getClass()) {
            TransactionRequest testTrans = (TransactionRequest)((Object)obj);
            boolean isEqual = true;
            if (this.releaseAction == testTrans.releaseAction) {
                isEqual = this.testField(this.lockId, testTrans.getLockId());
                boolean bl = isEqual = this.testField(this.handle, testTrans.getHandle()) && isEqual;
                if (this.subRequests.size() == testTrans.subRequests.size()) {
                    for (int i = 0; i < this.subRequests.size(); ++i) {
                        isEqual = isEqual && this.subRequests.contains(testTrans.getSubRequest(i));
                    }
                } else {
                    isEqual = false;
                }
            } else {
                isEqual = false;
            }
            return isEqual;
        }
        return false;
    }
}

