/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.gml.GMLFilterFeature;
import org.geotools.gml.GMLHandlerFeature;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.wfs.requests.TransactionFilterHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TransactionFeatureHandler
extends GMLFilterFeature {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests");
    private Object[] attributes;
    private List attributeNames = new Vector();
    private boolean insideAttribute = false;
    private boolean insideFeature = false;
    private boolean insideInsert = false;
    private Object tempValue = null;
    private StringBuffer processingAttributeValue;
    private String attName = "";
    private String typeName = "GenericFeature";
    private TransactionFilterHandler parent;
    private Data catalog = null;
    private FeatureType curFeatureType;
    private AttributeType curAttributeType;
    private StringBuffer characters = new StringBuffer();

    public TransactionFeatureHandler(TransactionFilterHandler parent, HttpServletRequest r, Data catalog) {
        super((GMLHandlerFeature)parent);
        this.parent = parent;
        this.catalog = catalog;
    }

    public void setCatalog(Data catalog) {
        this.catalog = catalog;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.characters.setLength(0);
        if (localName.equals("Insert")) {
            this.insideInsert = true;
        }
        LOGGER.finest("checking out " + namespaceURI + ", " + localName);
        this.processingAttributeValue = new StringBuffer();
        if (this.insideInsert && !localName.equals("Insert")) {
            FeatureTypeInfo fType = this.catalog.getFeatureTypeInfo(localName, namespaceURI);
            String internalTypeName = null;
            if (fType != null) {
                internalTypeName = fType.getName();
            }
            if (!this.insideFeature) {
                if (internalTypeName == null || fType == null) {
                    throw new SAXException("Could not find featureType with name " + localName + ", and uri: " + namespaceURI);
                }
                this.typeName = internalTypeName;
                try {
                    this.curFeatureType = fType.getFeatureType();
                }
                catch (IOException ioe) {
                    throw new SAXException(ioe);
                }
                int numAtts = this.curFeatureType.getAttributeTypes().length;
                this.attributes = new Object[numAtts];
                this.attributeNames = new Vector(numAtts);
                this.insideFeature = true;
                this.tempValue = null;
                LOGGER.finer("Starting a feature " + this.typeName);
            }
            if (this.insideFeature && !localName.equals("lineStringMember") && !localName.equals("polygonMember") && !localName.equals("pointMember")) {
                LOGGER.fine("inside feature " + internalTypeName);
                if (!this.typeName.equalsIgnoreCase(internalTypeName)) {
                    if (this.attName.equals("")) {
                        LOGGER.finest("setting attName to " + localName);
                        this.attName = localName;
                    } else {
                        LOGGER.finest("adding " + localName + " to " + this.attName);
                        this.attName = this.attName + "/" + localName;
                    }
                    this.curAttributeType = this.curFeatureType.getAttributeType(this.attName);
                    if (this.curAttributeType == null) {
                        throw new SAXException("Could not find attributeType named " + this.attName + "in featureType " + this.curFeatureType);
                    }
                    LOGGER.fine("attName now equals " + this.attName);
                    this.insideAttribute = true;
                }
                return;
            }
            if (this.insideAttribute) {
                LOGGER.finer("inside attribute");
            }
        } else {
            this.parent.startElement(namespaceURI, localName, qName, atts);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.handleCharacters();
        if (localName.equals("Insert")) {
            this.insideInsert = false;
        }
        FeatureTypeInfo fType = this.catalog.getFeatureTypeInfo(localName, namespaceURI);
        String internalTypeName = null;
        if (fType != null) {
            internalTypeName = fType.getName();
        }
        if (this.typeName.equals(internalTypeName)) {
            try {
                Feature feature = this.curFeatureType.create(this.attributes);
                this.parent.feature(feature);
                LOGGER.finest("resetting attName at end of feature");
                this.attName = "";
                LOGGER.finer("created feature: " + feature);
            }
            catch (IllegalAttributeException ife) {
                throw new RuntimeException("problem creating feature", ife);
            }
            this.insideFeature = false;
        } else if (this.insideAttribute && !localName.equals("lineStringMember") && !localName.equals("polygonMember") && !localName.equals("pointMember")) {
            int index;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("end - inside attribute [" + this.processingAttributeValue + "]");
            }
            if (this.processingAttributeValue != null && this.processingAttributeValue.length() > 0) {
                this.tempValue = this.curAttributeType.parse((Object)this.processingAttributeValue.toString());
                int insertPosition = this.curFeatureType.find(this.curAttributeType);
                Object curAtt = this.attributes[insertPosition];
                if (curAtt != null) {
                    throw new SAXException("Attempted to set attribute " + this.attName + " twice, first with " + curAtt + ", and then with " + this.tempValue + ".\n  Future " + "versions of GeoServer may support complex attributes");
                }
                this.attributes[insertPosition] = this.tempValue;
                this.tempValue = null;
                this.attributeNames.add(this.attName);
            }
            if ((index = this.attName.lastIndexOf(47)) > -1) {
                LOGGER.finest("removing " + this.attName.substring(index + 1));
                this.attName = this.attName.substring(0, index);
            } else {
                this.attName = "";
            }
            LOGGER.finer("attName now equals " + this.attName);
            this.insideAttribute = false;
        } else {
            this.attName = "";
            this.parent.endElement(namespaceURI, localName, qName);
            LOGGER.finest("end - inside feature");
        }
        this.processingAttributeValue = null;
    }

    public void geometry(Geometry geometry) {
        if (this.insideFeature) {
            LOGGER.fine("geometry recieved is " + geometry);
            if (this.attName.equals("")) {
                this.attributeNames.add("geometry");
            } else {
                this.attributeNames.add(this.attName);
            }
            int position = this.curFeatureType.find(this.curAttributeType);
            this.attributes[position] = geometry;
            this.insideAttribute = false;
            int index = this.attName.lastIndexOf(47);
            if (index > -1) {
                LOGGER.finest("removing " + this.attName.substring(index + 1));
                this.attName = this.attName.substring(0, index);
            } else {
                this.attName = "";
            }
            this.attName = "";
            LOGGER.finer("calling gmlFeatureFilter for geom " + geometry);
        } else {
            this.parent.geometry(geometry);
        }
    }

    private void handleCharacters() throws SAXException {
        if (this.characters.length() == 0) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("we are inside attribute: " + this.insideAttribute + ", curAttType is " + this.curAttributeType + " curFeatureT: " + this.curFeatureType + " attName " + this.attName);
        }
        if (this.insideAttribute && this.characters.length() > 0) {
            if (this.processingAttributeValue != null) {
                this.processingAttributeValue.append(this.characters);
            }
        } else {
            this.parent.characters(this.characters.toString().toCharArray(), 0, this.characters.length());
        }
        this.characters.setLength(0);
    }
}

