/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockFactory;
import org.geotools.filter.Filter;
import org.vfny.geoserver.wfs.requests.WFSRequest;
import org.vfny.geoserver.wfs.servlets.WFService;

public class LockRequest
extends WFSRequest {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.wfs");
    private String handle;
    protected int expiry = 0;
    protected boolean lockAll = true;
    protected List locks = new ArrayList();

    public LockRequest(WFService service) {
        super("LockFeature", service);
    }

    public FeatureLock toFeatureLock() {
        if (this.handle == null || this.handle.length() == 0) {
            this.handle = "GeoServer";
        }
        if (this.expiry < 0) {
            return FeatureLockFactory.generate((String)this.handle, (long)this.expiry);
        }
        if (this.expiry == 0) {
            return FeatureLockFactory.generate((String)this.handle, (long)0L);
        }
        return FeatureLockFactory.generate((String)this.handle, (long)(this.expiry * 60 * 1000));
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getHandle() {
        return this.handle;
    }

    public boolean getLockAll() {
        return this.lockAll;
    }

    public void setLockAll(boolean lockAll) {
        this.lockAll = lockAll;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public void setExpiry(int expiry) {
        this.expiry = expiry;
    }

    public int getExpirySeconds() {
        return this.expiry * 60;
    }

    public List getLocks() {
        return this.locks;
    }

    public void addLock(Lock lock) {
        this.locks.add(lock);
    }

    public void setLocks(List locks) {
        this.locks = locks;
    }

    public void setLocks(List typeList, List filterList) {
        ListIterator typeIterator = typeList.listIterator();
        ListIterator filterIterator = filterList.listIterator();
        this.locks = new ArrayList();
        while (typeIterator.hasNext()) {
            String curType = (String)typeIterator.next();
            Filter curFilter = null;
            if (filterIterator.hasNext()) {
                curFilter = (Filter)filterIterator.next();
            }
            this.addLock(curType, curFilter);
        }
    }

    public void addLock(String featureType, Filter filter, String handle) {
        Lock addLock = new Lock(featureType);
        addLock.setHandle(handle);
        addLock.setFilter(filter);
        this.locks.add(addLock);
    }

    public void addLock(String featureType, Filter filter) {
        Lock addLock = new Lock(featureType);
        addLock.setFilter(filter);
        this.locks.add(addLock);
    }

    public String toString() {
        StringBuffer returnString = new StringBuffer("\nLock Feature Request");
        String indent = "\n    ";
        returnString.append("\n LockAction: " + (this.lockAll ? "ALL" : "SOME"));
        returnString.append("\n exires in (min):" + this.expiry);
        ListIterator lockIterator = this.locks.listIterator();
        while (lockIterator.hasNext()) {
            returnString.append(lockIterator.next().toString() + indent);
        }
        return returnString.toString();
    }

    public boolean equals(Object obj) {
        super.equals(obj);
        if (!(obj instanceof LockRequest)) {
            return false;
        }
        boolean isEqual = true;
        LockRequest lrequest = (LockRequest)((Object)obj);
        isEqual = this.expiry == lrequest.getExpiry() ? isEqual : false;
        LOGGER.finest("checking expiry equality: " + isEqual);
        isEqual = this.lockAll == lrequest.getLockAll() ? isEqual : false;
        LOGGER.finest("checking locking equality: " + isEqual);
        ListIterator internalIterator = this.locks.listIterator();
        ListIterator externalIterator = lrequest.getLocks().listIterator();
        while (internalIterator.hasNext()) {
            if (!externalIterator.hasNext()) {
                isEqual = false;
                LOGGER.finest("lock lists not same size");
                break;
            }
            Lock internalLock = (Lock)internalIterator.next();
            Lock externalLock = (Lock)externalIterator.next();
            LOGGER.finest("internal lock: " + internalLock);
            LOGGER.finest("external lock: " + externalLock);
            if (!internalLock.equals(externalLock)) {
                isEqual = false;
            }
            LOGGER.finest("Locks match: " + isEqual);
        }
        return isEqual;
    }

    private static boolean testField(Object mine, Object test) {
        LOGGER.finest("testing " + mine + " and " + test);
        if (mine != null) {
            return mine.equals(test);
        }
        return test == null;
    }

    public static class Lock {
        protected String featureType = "";
        protected Filter filter;
        protected String handle;

        public Lock(String featureType) {
            this.featureType = featureType;
        }

        public String getFeatureType() {
            return this.featureType;
        }

        public void setFeatureType(String featureType) {
            this.featureType = featureType;
        }

        public Filter getFilter() {
            return this.filter;
        }

        public void setFilter(Filter filter) {
            this.filter = filter;
        }

        public String getHandle() {
            return this.handle;
        }

        public void setHandle(String handle) {
            this.handle = handle;
        }

        public String toString() {
            return "\n Lock\n   typeName: " + this.featureType + "\n   handle: " + this.handle + "\n   filter: " + this.filter;
        }

        public boolean equals(Object obj) {
            if (obj != null && obj.getClass() == this.getClass()) {
                Lock testLock = (Lock)obj;
                return LockRequest.testField(this.handle, testLock.getHandle()) && LockRequest.testField(this.featureType, testLock.getFeatureType()) && LockRequest.testField(this.filter, testLock.getFilter());
            }
            return false;
        }
    }
}

