/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.requests;

import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterHandler;
import org.vfny.geoserver.wfs.requests.LockRequest;
import org.vfny.geoserver.wfs.servlets.WFService;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class LockHandler
extends XMLFilterImpl
implements ContentHandler,
FilterHandler {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests");
    private LockRequest request = null;
    private String insideTag = "";
    private boolean insideLock = false;
    private Filter curFilter;
    private String curTypeName;
    private String curHandle;

    public LockHandler(WFService service) {
        this.request = new LockRequest(service);
    }

    public LockRequest getRequest(HttpServletRequest req) {
        this.request.setHttpServletRequest(req);
        return this.request;
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        block7: {
            block6: {
                LOGGER.finest("at start element: " + localName);
                this.insideTag = localName;
                if (!this.insideTag.equals("Lock")) break block6;
                this.insideLock = true;
                int n = atts.getLength();
                for (int i = 0; i < n; ++i) {
                    String name = atts.getLocalName(i);
                    String value = atts.getValue(i);
                    LOGGER.finest("found attribute '" + name + "'=" + value);
                    if (name.equals("typeName")) {
                        this.curTypeName = value;
                        continue;
                    }
                    if (!name.equals("handle")) continue;
                    this.curHandle = value;
                }
                break block7;
            }
            if (!this.insideTag.equals("LockFeature")) break block7;
            for (int i = 0; i < atts.getLength(); ++i) {
                if (atts.getLocalName(i).equals("expiry")) {
                    LOGGER.finest("foundExpiry: " + atts.getValue(i));
                    int expiry = -1;
                    try {
                        expiry = Integer.parseInt(atts.getValue(i));
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException("expiry should parse to an integer", e);
                    }
                    this.request.setExpiry(expiry);
                    continue;
                }
                if (!atts.getLocalName(i).equals("lockAction") || !atts.getValue(i).equalsIgnoreCase("SOME")) continue;
                this.request.setLockAll(false);
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        LOGGER.finer("at end element: " + localName);
        this.insideTag = "NULL";
        if (localName.equals("Lock")) {
            LOGGER.finest("adding lock: " + this.curTypeName + ", " + this.curHandle + ", " + this.curFilter);
            this.insideLock = false;
            this.request.addLock(this.curTypeName, this.curFilter, this.curHandle);
            this.curTypeName = null;
            this.curFilter = null;
            this.curHandle = null;
        }
    }

    public void filter(Filter filter) {
        LOGGER.finest("found filter: " + filter.toString());
        if (this.insideLock) {
            this.curFilter = filter;
        }
    }
}

