/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.geotools.data.DefaultQuery;
import org.geotools.filter.Filter;

public class Query {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests");
    protected String handle = "";
    protected String version = new String();
    protected String typeName = new String();
    protected List propertyNames = new ArrayList();
    protected Filter filter = null;
    protected boolean allRequested = true;

    public List getPropertyNames() {
        return this.propertyNames;
    }

    public void setPropertyNames(List l) {
        this.propertyNames = l;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    private String getName() {
        if (this.typeName.indexOf(":") == -1) {
            return this.typeName;
        }
        String[] splitName = this.typeName.split("[:]");
        String name = this.typeName;
        name = splitName.length == 1 ? splitName[0] : splitName[splitName.length - 1];
        return name;
    }

    public void addPropertyName(String propertyName) {
        String[] splitName = propertyName.split("[.:/]");
        String newPropName = propertyName;
        newPropName = splitName.length == 1 ? splitName[0] : splitName[splitName.length - 1];
        if (!this.propertyNames.contains(newPropName)) {
            this.propertyNames.add(newPropName);
        }
        this.allRequested = false;
    }

    public boolean allRequested() {
        return this.allRequested;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void addFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public org.geotools.data.Query getDataSourceQuery(int maxFeatures) {
        String[] props = null;
        if (this.propertyNames != null && this.propertyNames.size() > 0) {
            props = this.propertyNames.toArray(new String[0]);
        }
        DefaultQuery query = new DefaultQuery(this.getName(), this.filter, maxFeatures, props, this.handle);
        return query;
    }

    public org.geotools.data.Query toDataQuery(int maxFeatures) {
        if (maxFeatures <= 0) {
            maxFeatures = Integer.MAX_VALUE;
        }
        String[] props = null;
        if (this.propertyNames != null && this.propertyNames.size() > 0) {
            props = this.propertyNames.toArray(new String[this.propertyNames.size()]);
        }
        if (this.filter == null) {
            this.filter = Filter.NONE;
        }
        DefaultQuery query = new DefaultQuery(this.getName(), this.filter, maxFeatures, props, this.handle);
        return query;
    }

    public String toString() {
        StringBuffer returnString = new StringBuffer("\n  Query");
        returnString.append(" [" + this.handle + "]");
        returnString.append("\n   feature type: " + this.typeName);
        if (this.filter != null) {
            returnString.append("\n   filter: " + this.filter.toString());
        }
        returnString.append("\n   [properties: ");
        if (this.allRequested()) {
            return returnString + " ALL ]";
        }
        ListIterator iterator = this.propertyNames.listIterator();
        while (iterator.hasNext()) {
            returnString.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            returnString.append(", ");
        }
        returnString.append("]");
        return returnString.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Query)) {
            return false;
        }
        Query query = (Query)obj;
        boolean isEqual = true;
        isEqual = query.getHandle().equals(this.handle) ? isEqual : false;
        LOGGER.finest("checked handle: " + isEqual);
        isEqual = query.getTypeName().equals(this.typeName) ? isEqual : false;
        LOGGER.finest("checked feature type: " + isEqual + "; internal: " + query.getTypeName() + "; external: " + this.typeName);
        isEqual = query.getVersion().equals(this.version) ? isEqual : false;
        LOGGER.finest("checked version: " + isEqual);
        if (query.getFilter() != null) {
            LOGGER.finest("checking filter: " + this.filter);
            isEqual = query.getFilter().equals(this.filter) ? isEqual : false;
            LOGGER.finest("checked filter: " + isEqual);
        } else {
            isEqual = this.filter == null ? isEqual : false;
        }
        LOGGER.finest("checking properties, internal: " + this.propertyNames.size() + "; external: " + query.getPropertyNames().size());
        if (this.propertyNames.size() == query.getPropertyNames().size()) {
            ListIterator i = this.propertyNames.listIterator();
            ListIterator e = query.getPropertyNames().listIterator();
            while (i.hasNext()) {
                isEqual = i.next().equals(e.next()) ? isEqual : false;
            }
        } else {
            isEqual = false;
        }
        return isEqual;
    }

    public int hashCode() {
        int result = 17;
        result = 23 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        result = 23 * result + (this.propertyNames == null ? 0 : ((Object)this.propertyNames).hashCode());
        return result;
    }
}

