/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import org.vfny.geoserver.global.Config;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GeoValidator;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.dto.ServiceDTO;
import org.vfny.geoserver.global.dto.WFSDTO;

public class WFS
extends Service {
    public static final String WEB_CONTAINER_KEY = "WFS";
    private GeoValidator gv;
    private int serviceLevel;
    private boolean srsXmlStyle;
    private boolean citeConformanceHacks;
    private boolean featureBounding;

    public WFS(WFSDTO config) {
        super(config.getService());
        this.srsXmlStyle = config.isSrsXmlStyle();
        this.serviceLevel = config.getServiceLevel();
        this.citeConformanceHacks = config.getCiteConformanceHacks();
        this.featureBounding = config.isFeatureBounding();
    }

    public WFS(Config config, Data data, GeoServer geoServer, GeoValidator validator) throws ConfigurationException {
        this(config.getXMLReader().getWfs());
        this.setData(data);
        this.setGeoServer(geoServer);
        this.setValidation(validator);
    }

    WFS() {
        super(new ServiceDTO());
    }

    public void load(WFSDTO config) {
        super.load(config.getService());
        this.srsXmlStyle = config.isSrsXmlStyle();
        this.serviceLevel = config.getServiceLevel();
        this.citeConformanceHacks = config.getCiteConformanceHacks();
        this.featureBounding = config.isFeatureBounding();
    }

    public Object toDTO() {
        WFSDTO dto = new WFSDTO();
        dto.setService((ServiceDTO)super.toDTO());
        dto.setServiceLevel(this.serviceLevel);
        dto.setSrsXmlStyle(this.srsXmlStyle);
        dto.setCiteConformanceHacks(this.citeConformanceHacks);
        dto.setFeatureBounding(this.featureBounding);
        return dto;
    }

    public boolean isSrsXmlStyle() {
        return this.srsXmlStyle;
    }

    public void setSrsXmlStyle(boolean doXmlStyle) {
        this.srsXmlStyle = doXmlStyle;
    }

    public String getSrsPrefix() {
        return this.srsXmlStyle ? "http://www.opengis.net/gml/srs/epsg.xml#" : "EPSG:";
    }

    public GeoValidator getValidation() {
        return this.gv;
    }

    void setValidation(GeoValidator gv) {
        this.gv = gv;
    }

    public int getServiceLevel() {
        return this.serviceLevel;
    }

    public void setCiteConformanceHacks(boolean on) {
        this.citeConformanceHacks = on;
    }

    public boolean getCiteConformanceHacks() {
        return this.citeConformanceHacks;
    }

    public boolean isFeatureBounding() {
        return this.featureBounding;
    }

    public void setFeatureBounding(boolean featureBounding) {
        this.featureBounding = featureBounding;
    }
}

