/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.impl.MetadataLinkInfoImpl;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.data.DataStore;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.AttributeTypeInfoConfig;
import org.vfny.geoserver.config.ConfigRequests;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.DataStoreConfig;
import org.vfny.geoserver.config.FeatureTypeConfig;
import org.vfny.geoserver.config.StyleConfig;
import org.vfny.geoserver.form.data.AttributeDisplay;
import org.vfny.geoserver.form.data.AttributeForm;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.DataTransferObjectFactory;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.wms.responses.map.kml.RegionatingStrategyFactory;

public class TypesEditorForm
extends ActionForm {
    static final List schemaBases;
    static final List allMetadataURLTypes;
    private String dataStoreId;
    private String styleId;
    private SortedSet panelStyleIds;
    private SortedSet typeStyles;
    private String[] otherSelectedStyles;
    private String typeName;
    private String alias;
    private String wmsPath;
    private String SRS;
    private String SRSWKT;
    private String nativeSRSWKT;
    private List allSrsHandling;
    private int srsHandling = FeatureTypeInfo.FORCE;
    private String title;
    private String minX;
    private String minY;
    private String maxX;
    private String maxY;
    private String keywords;
    private MetaDataLink[] metadataLinks;
    private String[] metadataURLTypes;
    private String description;
    private String regionateAttribute;
    private String regionateStrategy;
    private String regionateFeatureLimit;
    private SortedSet availableStrategies;
    private String cacheMaxAge;
    private String maxFeatures = "";
    private boolean cachingEnabled;
    private boolean cachingEnabledChecked = false;
    private boolean indexingEnabled;
    private boolean indexingEnabledChecked = false;
    private String schemaBase;
    private String schemaName;
    private List attributes;
    private List addList;
    private String action;
    private SortedSet styles;
    private String autoGenerateExtent;
    private String newAttribute;
    private String dataMinX;
    private String dataMinY;
    private String dataMaxX;
    private String dataMaxY;
    private CoordinateReferenceSystem declaredCRS;
    private CoordinateReferenceSystem nativeCRS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(ActionMapping mapping, HttpServletRequest request) {
        SimpleFeatureType featureType;
        ServletContext servletContext;
        super.reset(mapping, request);
        this.action = "";
        ServletContext context = servletContext = this.getServlet().getServletContext();
        DataConfig config = ConfigRequests.getDataConfig((HttpServletRequest)request);
        UserContainer user = Requests.getUserContainer((HttpServletRequest)request);
        FeatureTypeConfig type = user.getFeatureTypeConfig();
        if (type == null) {
            System.out.println("Type is not there");
            return;
        }
        this.dataStoreId = type.getDataStoreId();
        this.styleId = type.getDefaultStyle();
        this.description = type.getAbstract();
        this.regionateAttribute = type.getRegionateAttribute();
        this.regionateStrategy = type.getRegionateStrategy();
        this.regionateFeatureLimit = Integer.toString(type.getRegionateFeatureLimit());
        this.availableStrategies = new TreeSet();
        List factories = GeoServerExtensions.extensions(RegionatingStrategyFactory.class);
        Iterator it = factories.iterator();
        while (it.hasNext()) {
            this.availableStrategies.add(((RegionatingStrategyFactory)it.next()).getName());
        }
        this.maxFeatures = type.getMaxFeatures() == 0 ? String.valueOf(type.getMaxFeatures()) : "";
        this.cacheMaxAge = type.getCacheMaxAge();
        this.cachingEnabled = type.isCachingEnabled();
        this.cachingEnabledChecked = false;
        this.indexingEnabled = type.isIndexingEnabled();
        this.indexingEnabledChecked = false;
        this.maxFeatures = String.valueOf(type.getMaxFeatures());
        Envelope bounds = type.getLatLongBBox();
        if (bounds == null || bounds.isNull()) {
            this.minX = "";
            this.minY = "";
            this.maxY = "";
            this.maxX = "";
        } else {
            this.minX = Double.toString(bounds.getMinX());
            this.minY = Double.toString(bounds.getMinY());
            this.maxX = Double.toString(bounds.getMaxX());
            this.maxY = Double.toString(bounds.getMaxY());
        }
        Envelope nativeBounds = type.getNativeBBox();
        if (nativeBounds == null || nativeBounds.isNull()) {
            this.dataMinX = "";
            this.dataMinY = "";
            this.dataMaxX = "";
            this.dataMaxY = "";
        } else {
            this.dataMinX = Double.toString(nativeBounds.getMinX());
            this.dataMinY = Double.toString(nativeBounds.getMinY());
            this.dataMaxX = Double.toString(nativeBounds.getMaxX());
            this.dataMaxY = Double.toString(nativeBounds.getMaxY());
        }
        this.typeName = type.getName();
        this.alias = type.getAlias();
        this.setSRS(Integer.toString(type.getSRS()));
        this.srsHandling = type.getSRSHandling();
        this.nativeSRSWKT = "-";
        DataStore dataStore = null;
        try {
            DataConfig dataConfig = (DataConfig)servletContext.getAttribute("Config.Data");
            DataStoreConfig dsConfig = dataConfig.getDataStore(type.getDataStoreId());
            dataStore = dsConfig.findDataStore(servletContext);
            featureType = dataStore.getSchema(type.getName());
            GeometryDescriptor dg = featureType.getGeometryDescriptor();
            if (dg != null && dg.getCoordinateReferenceSystem() != null) {
                this.nativeCRS = dg.getCoordinateReferenceSystem();
                this.nativeSRSWKT = dg.getCoordinateReferenceSystem().toString();
            }
        }
        catch (Exception e) {
        }
        finally {
            if (dataStore != null) {
                dataStore.dispose();
            }
        }
        MessageResources resources = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        this.allSrsHandling = this.nativeSRSWKT == "-" ? Arrays.asList(resources.getMessage("label.type.forceSRS")) : Arrays.asList(resources.getMessage("label.type.forceSRS"), resources.getMessage("label.type.reprojectSRS"), resources.getMessage("label.type.leaveSRS"));
        this.title = type.getTitle();
        this.wmsPath = type.getWmsPath();
        System.out.println("rest based on schemaBase: " + type.getSchemaBase());
        DataStoreConfig dataStoreConfig = config.getDataStore(this.dataStoreId);
        featureType = null;
        try {
            dataStore = dataStoreConfig.findDataStore(servletContext);
            featureType = dataStore.getSchema(this.typeName);
        }
        catch (IOException e) {
        }
        finally {
            if (dataStore != null) {
                dataStore.dispose();
            }
        }
        if (featureType == null) {
            this.schemaBase = "--";
            this.schemaName = this.typeName + "_Type";
            this.attributes = new LinkedList();
            this.addList = Collections.EMPTY_LIST;
        } else if (type.getSchemaBase() == null || "--".equals(type.getSchemaBase()) || type.getSchemaAttributes() == null) {
            this.schemaBase = "--";
            this.schemaName = this.typeName + "_Type";
            this.attributes = new LinkedList();
            List generated = DataTransferObjectFactory.generateAttributes((SimpleFeatureType)featureType);
            this.attributes = this.attributesDisplayList(generated);
            this.addList = Collections.EMPTY_LIST;
        } else {
            this.schemaBase = type.getSchemaBase();
            this.schemaName = type.getSchemaName();
            this.attributes = new LinkedList();
            List schemaAttributes = DataTransferObjectFactory.generateRequiredAttributes((String)this.schemaBase);
            this.attributes.addAll(this.attributesDisplayList(schemaAttributes));
            this.attributes.addAll(this.attributesFormList(type.getSchemaAttributes(), featureType));
            this.addList = new ArrayList(featureType.getAttributeCount());
            for (int i = 0; i < featureType.getAttributeCount(); ++i) {
                String attributeName = featureType.getDescriptor(i).getLocalName();
                if (this.lookUpAttribute(attributeName) != null) continue;
                this.addList.add(attributeName);
            }
        }
        StringBuffer buf = new StringBuffer();
        Iterator<Object> i = type.getKeywords().iterator();
        while (i.hasNext()) {
            String keyword = (String)i.next();
            buf.append(keyword);
            if (!i.hasNext()) continue;
            buf.append(" ");
        }
        this.keywords = buf.toString();
        this.metadataLinks = new MetaDataLink[2];
        this.metadataLinks[0] = new MetaDataLink((MetadataLinkInfo)new MetadataLinkInfoImpl());
        this.metadataLinks[0].setType("text/plain");
        this.metadataLinks[1] = new MetaDataLink((MetadataLinkInfo)new MetadataLinkInfoImpl());
        this.metadataLinks[1].setType("text/plain");
        if (type.getMetadataLinks() != null && type.getMetadataLinks().size() > 0) {
            ArrayList links = new ArrayList(type.getMetadataLinks());
            MetaDataLink link = (MetaDataLink)links.get(0);
            this.metadataLinks[0] = new MetaDataLink((MetadataLinkInfo)new MetadataLinkInfoImpl()).load(link);
            if (links.size() > 1) {
                link = (MetaDataLink)links.get(1);
                this.metadataLinks[1] = new MetaDataLink((MetadataLinkInfo)new MetadataLinkInfoImpl()).load(link);
            }
        }
        this.styles = new TreeSet();
        for (StyleConfig sc : config.getStyles().values()) {
            this.styles.add(sc.getId());
            if (!sc.isDefault() || this.styleId != null && !this.styleId.equals("")) continue;
            this.styleId.equals(sc.getId());
        }
        this.typeStyles = new TreeSet();
        for (String styleName : type.getStyles()) {
            this.typeStyles.add(styleName);
        }
        SortedSet attribute = this.styles;
        if (attribute instanceof AttributeDisplay) {
            // empty if block
        }
    }

    private Object lookUpAttribute(String name) {
        for (Object attribute : this.attributes) {
            if (attribute instanceof AttributeDisplay && name.equals(((AttributeDisplay)attribute).getName())) {
                return attribute;
            }
            if (!(attribute instanceof AttributeForm) || !name.equals(((AttributeForm)attribute).getName())) continue;
            return attribute;
        }
        return null;
    }

    private List attributesDisplayList(List dtoList) {
        ArrayList<AttributeDisplay> list = new ArrayList<AttributeDisplay>();
        int index = 0;
        for (Object next : dtoList) {
            list.add(new AttributeDisplay(new AttributeTypeInfoConfig((AttributeTypeInfoDTO)next)));
            ++index;
        }
        return list;
    }

    private List attributesFormList(List dtoList, SimpleFeatureType schema) {
        ArrayList<AttributeForm> list = new ArrayList<AttributeForm>();
        for (AttributeTypeInfoConfig config : dtoList) {
            list.add(new AttributeForm(config, schema.getDescriptor(config.getName())));
        }
        return list;
    }

    public List toSchemaAttributes() {
        if (this.schemaBase == null || this.schemaBase.equals("--")) {
            return null;
        }
        ArrayList<AttributeTypeInfoConfig> list = new ArrayList<AttributeTypeInfoConfig>();
        for (Object obj : this.attributes) {
            if (!(obj instanceof AttributeForm)) continue;
            AttributeForm form = (AttributeForm)obj;
            list.add(form.toConfig());
        }
        return list;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        Locale locale = request.getLocale();
        MessageResources messages = (MessageResources)request.getAttribute("org.apache.struts.action.MESSAGE");
        String BBOX = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.calculateBoundingBox.label"));
        String SLDWIZARD = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.sldWizard.label"));
        String LOOKUP_SRS = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.lookupSRS.label"));
        if (this.autoGenerateExtent == null) {
            this.autoGenerateExtent = "false";
        }
        if (this.action.startsWith("Up") || this.action.startsWith("Down") || this.action.startsWith("Remove") || this.action.equals(BBOX) || this.action.equals(SLDWIZARD) || this.action.equals(LOOKUP_SRS)) {
            return errors;
        }
        DataConfig data = ConfigRequests.getDataConfig((HttpServletRequest)request);
        if (!data.getStyles().containsKey(this.styleId) && !"".equals(this.styleId)) {
            errors.add("styleId", new ActionError("error.styleId.notFound", (Object)this.styleId));
        }
        if (!this.autoGenerateExtent.equals("true")) {
            if ("".equals(this.minX) || "".equals(this.minY) || "".equals(this.maxX) || "".equals(this.maxY)) {
                errors.add("latlongBoundingBox", new ActionError("error.latLonBoundingBox.required"));
            } else {
                try {
                    Double.parseDouble(this.minX);
                    Double.parseDouble(this.minY);
                    Double.parseDouble(this.maxX);
                    Double.parseDouble(this.maxY);
                }
                catch (NumberFormatException badNumber) {
                    errors.add("latlongBoundingBox", new ActionError("error.latLonBoundingBox.invalid", (Object)badNumber));
                }
            }
        }
        if (this.isCachingEnabledChecked()) {
            try {
                Integer.parseInt(this.cacheMaxAge);
            }
            catch (NumberFormatException nfe) {
                errors.add("cacheMaxAge", new ActionError("error.cacheMaxAge.malformed", (Object)nfe));
            }
            catch (Throwable t) {
                errors.add("cacheMaxAge", new ActionError("error.cacheMaxAge.error", (Object)t));
            }
        }
        try {
            int maxFeatures = Integer.parseInt(this.maxFeatures);
            if (maxFeatures < 0) {
                errors.add("maxFeaturews", new ActionError("error.global.maxFeatures"));
            }
        }
        catch (NumberFormatException nfe) {
            errors.add("maxFeaturews", new ActionError("error.global.maxFeatures", (Object)nfe));
        }
        try {
            int SRSnum = Integer.valueOf(this.SRS);
            CRS.decode((String)("EPSG:" + this.SRS));
        }
        catch (NumberFormatException badNumber) {
            errors.add("SRS", new ActionError("error.srs.invalid", (Object)badNumber));
        }
        catch (NoSuchAuthorityCodeException nsace) {
            errors.add("SRS", new ActionError("error.srs.unknown"));
        }
        catch (FactoryException fe) {
            errors.add("SRS", new ActionError("error.srs.unknown"));
        }
        return errors;
    }

    public List getAllYourBase() {
        return schemaBases;
    }

    public List getAllMetadataURLTypes() {
        return allMetadataURLTypes;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public SortedSet getAttributeNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (Object o : this.attributes) {
            names.add(((AttributeDisplay)o).getName());
        }
        return names;
    }

    public SortedSet getAttributeDescriptions() {
        TreeSet<String> descriptions = new TreeSet<String>();
        for (Object o : this.attributes) {
            AttributeDisplay ad = (AttributeDisplay)o;
            descriptions.add(ad.getName() + ": " + ad.getType());
        }
        return descriptions;
    }

    public void setAttributes(List attributes) {
        this.attributes = attributes;
    }

    public String getDataStoreId() {
        return this.dataStoreId;
    }

    public void setDataStoreId(String dataStoreId) {
        this.dataStoreId = dataStoreId;
    }

    public String getAbstract() {
        return this.description;
    }

    public String getRegionateAttribute() {
        return this.regionateAttribute;
    }

    public String getRegionateStrategy() {
        return this.regionateStrategy;
    }

    public String getRegionateFeatureLimit() {
        return this.regionateFeatureLimit;
    }

    public SortedSet getAvailableStrategies() {
        return this.availableStrategies;
    }

    public void setAbstract(String description) {
        this.description = description;
    }

    public void setRegionateAttribute(String attr) {
        this.regionateAttribute = attr;
    }

    public void setRegionateStrategy(String strat) {
        this.regionateStrategy = strat;
    }

    public void setRegionateFeatureLimit(String limit) {
        this.regionateFeatureLimit = limit;
    }

    public void setAvailableStrategies(SortedSet strategies) {
        this.availableStrategies = strategies;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public MetaDataLink getMetadataLink(int index) {
        return this.metadataLinks[index];
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String name) {
        this.typeName = name;
    }

    public String getSchemaBase() {
        return this.schemaBase;
    }

    public void setSchemaBase(String schemaBase) {
        this.schemaBase = schemaBase;
    }

    public String getSRS() {
        return this.SRS;
    }

    public String getSRSWKT() {
        return this.SRSWKT;
    }

    public String getNativeSRSWKT() {
        return this.nativeSRSWKT;
    }

    public void setSRS(String srs) {
        this.SRS = srs;
        try {
            String newSrs = srs;
            if (newSrs.indexOf(58) == -1) {
                newSrs = "EPSG:" + srs;
            }
            this.declaredCRS = CRS.decode((String)newSrs);
            this.SRSWKT = this.declaredCRS.toString();
        }
        catch (FactoryException e) {
            this.SRSWKT = "Could not find a definition for: EPSG:" + srs;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getMaxX() {
        return this.maxX;
    }

    public void setMaxX(String maxX) {
        this.maxX = maxX;
    }

    public String getMaxY() {
        return this.maxY;
    }

    public void setMaxY(String maxY) {
        this.maxY = maxY;
    }

    public String getMinX() {
        return this.minX;
    }

    public void setMinX(String minX) {
        this.minX = minX;
    }

    public String getMinY() {
        return this.minY;
    }

    public void setMinY(String minY) {
        this.minY = minY;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        this.styleId = styleId;
    }

    public SortedSet getStyles() {
        return this.styles;
    }

    public void setStyles(SortedSet styles) {
        this.styles = styles;
    }

    public Object getAttribute(int index) {
        return this.attributes.get(index);
    }

    public void setAttribute(int index, Object attribute) {
        this.attributes.set(index, attribute);
    }

    public String getNewAttribute() {
        return this.newAttribute;
    }

    public void setNewAttribute(String newAttribute) {
        this.newAttribute = newAttribute;
    }

    public String getAutoGenerateExtent() {
        if (this.autoGenerateExtent == null) {
            this.autoGenerateExtent = "false";
        }
        return this.autoGenerateExtent;
    }

    public void setAutoGenerateExtent(String autoGenerateExtent) {
        this.autoGenerateExtent = autoGenerateExtent;
    }

    public List getCreateableAttributes() {
        return this.addList;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setDataMinX(String x) {
        this.dataMinX = x;
    }

    public void setDataMinY(String x) {
        this.dataMinY = x;
    }

    public void setDataMaxX(String x) {
        this.dataMaxX = x;
    }

    public void setDataMaxY(String x) {
        this.dataMaxY = x;
    }

    public String getDataMinX() {
        return this.dataMinX;
    }

    public String getDataMinY() {
        return this.dataMinY;
    }

    public String getDataMaxX() {
        return this.dataMaxX;
    }

    public String getDataMaxY() {
        return this.dataMaxY;
    }

    public String getWmsPath() {
        return this.wmsPath;
    }

    public void setWmsPath(String wmsPath) {
        this.wmsPath = wmsPath;
    }

    public String getCacheMaxAge() {
        return this.cacheMaxAge;
    }

    public void setCacheMaxAge(String cacheMaxAge) {
        this.cacheMaxAge = cacheMaxAge;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public boolean isIndexingEnabled() {
        return this.indexingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabledChecked = true;
        this.cachingEnabled = cachingEnabled;
    }

    public void setIndexingEnabled(boolean indexingEnabled) {
        this.indexingEnabledChecked = true;
        this.indexingEnabled = true;
    }

    public boolean isCachingEnabledChecked() {
        return this.cachingEnabledChecked;
    }

    public boolean isIndexingEnabledChecked() {
        return this.indexingEnabledChecked;
    }

    public String[] getOtherSelectedStyles() {
        return this.otherSelectedStyles;
    }

    public void setOtherSelectedStyles(String[] otherSelectedStyles) {
        this.otherSelectedStyles = otherSelectedStyles;
    }

    public SortedSet getPanelStyleIds() {
        return this.panelStyleIds;
    }

    public SortedSet getTypeStyles() {
        return this.typeStyles;
    }

    public List getAllSrsHandling() {
        return this.allSrsHandling;
    }

    public String getSrsHandling() {
        if (this.srsHandling >= 0 && this.srsHandling < this.allSrsHandling.size()) {
            return (String)this.allSrsHandling.get(this.srsHandling);
        }
        return (String)this.allSrsHandling.get(0);
    }

    public void setSrsHandling(String handling) {
        this.srsHandling = this.allSrsHandling.indexOf(handling);
        if (this.srsHandling == -1) {
            this.srsHandling = FeatureTypeInfo.FORCE;
        }
    }

    public int getSrsHandlingCode() {
        return this.srsHandling;
    }

    public void setSrsHandlingCode(int code) {
        this.srsHandling = code;
    }

    public boolean isDeclaredCRSDifferent() {
        return this.nativeCRS == null || this.declaredCRS != null && !CRS.equalsIgnoreMetadata((Object)this.declaredCRS, (Object)this.nativeCRS);
    }

    public String getMaxFeatures() {
        return this.maxFeatures;
    }

    public void setMaxFeatures(String maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias != null ? alias.trim() : alias;
    }

    static {
        ArrayList<String> bases = new ArrayList<String>();
        bases.add("--");
        bases.addAll(DataTransferObjectFactory.schemaBaseMap.keySet());
        schemaBases = Collections.unmodifiableList(bases);
        allMetadataURLTypes = Arrays.asList("FGDC", "TC211");
    }
}

