/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.upload.FormFile;
import org.vfny.geoserver.config.ConfigRequests;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.StyleConfig;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.Requests;

public class StylesEditorForm
extends ActionForm {
    private String styleID;
    private String filename;
    private FormFile sldFile = null;
    private boolean _default;
    private boolean defaultChecked = false;
    private boolean defaultInitial;
    private String[] validationReport = null;
    private String sldContents;
    private String action;
    private boolean fullyValidate;
    private boolean fullyValidateChecked;
    private String originalStyleId;

    public void reset(ActionMapping arg0, HttpServletRequest request) {
        this.validationReport = null;
        super.reset(arg0, request);
        DataConfig config = ConfigRequests.getDataConfig((HttpServletRequest)request);
        UserContainer user = Requests.getUserContainer((HttpServletRequest)request);
        StyleConfig style = user.getStyle();
        this.fullyValidate = true;
        this.fullyValidateChecked = false;
        if (style == null) {
            this.styleID = "";
            this.originalStyleId = "";
            this._default = config.getStyles().isEmpty();
            this.filename = "";
            this.sldFile = null;
        } else {
            this.styleID = style.getId();
            this.originalStyleId = style.getId();
            this._default = style.isDefault();
            if (style.getFilename() != null) {
                this.filename = style.getFilename().getName();
            }
            this.sldFile = null;
        }
        this.sldContents = this.readSldFileContents(this.filename);
        this.defaultChecked = false;
        this.defaultInitial = this._default;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.styleID == null || this.styleID.equals("")) {
            errors.add("styleID", new ActionError("error.styleID.required", (Object)this.styleID));
            return errors;
        }
        if (!Pattern.matches("^[-\\w.:]*$", this.styleID)) {
            errors.add("styleID", new ActionError("error.styleID.invalid", (Object)this.styleID));
            return errors;
        }
        Boolean maxSize = (Boolean)request.getAttribute("org.apache.struts.upload.MaxLengthExceeded");
        if (maxSize != null && maxSize.booleanValue()) {
            String size = null;
            ControllerConfig cc = mapping.getModuleConfig().getControllerConfig();
            size = cc == null ? Long.toString(0xFA00000L) : cc.getMaxFileSize();
            errors.add("styleID", new ActionError("error.file.maxLengthExceeded", (Object)size));
            return errors;
        }
        this.filename = this.getSldFile().getFileName();
        return errors;
    }

    public boolean isDefault() {
        return this._default;
    }

    public void setDefault(boolean _default) {
        this.defaultChecked = true;
        this._default = _default;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public FormFile getSldFile() {
        return this.sldFile;
    }

    public void setSldFile(FormFile filename) {
        this.sldFile = filename;
    }

    public boolean getFullyValidateChecked() {
        return this.fullyValidateChecked;
    }

    public void setFullyValidateChecked(boolean fullyValidateChecked) {
        this.fullyValidateChecked = fullyValidateChecked;
    }

    public boolean getFullyValidate() {
        return this.fullyValidate;
    }

    public void setFullyValidate(boolean fullyValidate) {
        this.fullyValidateChecked = true;
        this.fullyValidate = fullyValidate;
    }

    public String getStyleID() {
        return this.styleID;
    }

    public void setStyleID(String styleID) {
        this.styleID = styleID;
    }

    public boolean isDefaultValue() {
        if (this.defaultChecked) {
            return this._default;
        }
        return this.defaultInitial;
    }

    public String getValidationReportIndexed(int i) {
        return this.validationReport[i];
    }

    public String[] getValidationReport() {
        return this.validationReport;
    }

    public void setValidationReport(String[] exs) {
        this.validationReport = exs;
    }

    public String readSldFileContents(String sldFileName) {
        if (sldFileName == null) {
            return "";
        }
        BufferedReader br = null;
        try {
            String s;
            File styleDir = new File(GeoserverDataDirectory.getGeoserverDataDirectory(), "styles");
            File styleFile = new File(styleDir, sldFileName);
            br = new BufferedReader(new FileReader(styleFile));
            StringBuffer sb = new StringBuffer();
            while ((s = br.readLine()) != null) {
                sb.append(s.replaceAll("\t", "  ")).append("\n");
            }
            br.close();
            return sb.toString();
        }
        catch (Throwable t) {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return "-";
        }
    }

    public String getSldContents() {
        return this.sldContents;
    }

    public void setSldContents(String sldContents) {
        this.sldContents = sldContents;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getOriginalStyleId() {
        return this.originalStyleId;
    }
}

