/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.data;

import java.util.ArrayList;
import java.util.List;
import org.opengis.feature.type.AttributeDescriptor;
import org.vfny.geoserver.config.AttributeTypeInfoConfig;
import org.vfny.geoserver.global.dto.AttributeTypeInfoDTO;
import org.vfny.geoserver.global.dto.DataTransferObjectFactory;
import org.vfny.geoserver.global.xml.NameSpaceElement;

public class AttributeForm {
    private String name;
    private boolean nillable;
    private String minOccurs;
    private String maxOccurs;
    private String type;
    private String fragment;
    private AttributeDescriptor attributeType;

    public AttributeForm(AttributeTypeInfoConfig config, AttributeDescriptor attribute) {
        this.name = config.getName();
        this.nillable = config.isNillable();
        this.minOccurs = String.valueOf(config.getMinOccurs());
        this.maxOccurs = String.valueOf(config.getMaxOccurs());
        this.type = config.getType();
        this.fragment = config.getFragment();
        this.attributeType = attribute;
    }

    public AttributeTypeInfoDTO toDTO() {
        AttributeTypeInfoDTO dto = new AttributeTypeInfoDTO();
        dto.setName(this.name);
        dto.setNillable(this.nillable);
        dto.setMinOccurs(Integer.parseInt(this.minOccurs));
        dto.setMaxOccurs(Integer.parseInt(this.maxOccurs));
        if ("(xml fragment)".equals(this.type)) {
            dto.setComplex(true);
            dto.setType(this.fragment);
        } else {
            dto.setComplex(false);
            dto.setType(this.type);
        }
        return dto;
    }

    public AttributeTypeInfoConfig toConfig() {
        return new AttributeTypeInfoConfig(this.toDTO());
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }

    public String getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(String maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public String getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(String minOccurs) {
        this.minOccurs = minOccurs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setNillable(boolean nillible) {
        this.nillable = nillible;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String selectedType) {
        this.type = selectedType;
    }

    public AttributeDescriptor getAttributeType() {
        return this.attributeType;
    }

    public List getTypes() {
        List elements = DataTransferObjectFactory.getElements((String)this.name, (Class)this.attributeType.getType().getBinding());
        ArrayList<String> list = new ArrayList<String>(elements.size());
        for (NameSpaceElement element : elements) {
            if (element.isAbstract()) continue;
            list.add(element.getTypeDefName());
        }
        list.add("(xml fragment)");
        return list;
    }
}

