/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.DataStoreConfig;
import org.vfny.geoserver.config.FeatureTypeConfig;
import org.vfny.geoserver.form.data.DataDataStoresSelectForm;
import org.vfny.geoserver.global.UserContainer;

public class DataDataStoresSelectAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm incomingForm, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DataDataStoresSelectForm form = (DataDataStoresSelectForm)incomingForm;
        String buttonAction = form.getButtonAction();
        DataConfig dataConfig = this.getDataConfig();
        DataStoreConfig dsConfig = null;
        Locale locale = request.getLocale();
        MessageResources messages = this.getResources(request);
        String editLabel = messages.getMessage(locale, "label.edit");
        String deleteLabel = messages.getMessage(locale, "label.delete");
        String selectedDataStore = form.getSelectedDataStoreId();
        if (editLabel.equals(buttonAction)) {
            dsConfig = dataConfig.getDataStore(selectedDataStore);
            this.getUserContainer(request).setDataStoreConfig(dsConfig);
            return mapping.findForward("config.data.store.editor");
        }
        if (deleteLabel.equals(buttonAction)) {
            int count = this.countFeatureTypesUsingStore(dataConfig, selectedDataStore);
            if (count > 0) {
                ActionErrors errors = new ActionErrors();
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.delete.datastore", (Object)selectedDataStore, (Object)count));
                this.saveErrors(request, errors);
            } else {
                dataConfig.removeDataStore(selectedDataStore);
                this.getUserContainer(request).setDataStoreConfig(null);
            }
            form.reset(mapping, request);
            return mapping.findForward("config.data.store");
        }
        throw new ServletException("Action '" + buttonAction + "'must be '" + editLabel + "' or '" + deleteLabel + "'");
    }

    private int countFeatureTypesUsingStore(DataConfig dataConfig, String selectedDataStore) {
        int count = 0;
        for (FeatureTypeConfig ft : dataConfig.getFeaturesTypes().values()) {
            if (!selectedDataStore.equals(ft.getDataStoreId())) continue;
            ++count;
        }
        return count;
    }
}

