/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.CoverageConfig;
import org.vfny.geoserver.config.CoverageStoreConfig;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.NameSpaceConfig;
import org.vfny.geoserver.config.WMSConfig;
import org.vfny.geoserver.form.data.DataCoveragesSelectForm;
import org.vfny.geoserver.global.UserContainer;

public class DataCoveragesSelectAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm incomingForm, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DataCoveragesSelectForm form = (DataCoveragesSelectForm)incomingForm;
        String selectedCoverage = form.getSelectedCoverageName();
        String buttonAction = form.getButtonAction();
        DataConfig dataConfig = (DataConfig)this.getServlet().getServletContext().getAttribute("Config.Data");
        CoverageConfig cvConfig = dataConfig.getCoverageConfig(selectedCoverage);
        Locale locale = request.getLocale();
        MessageResources messages = this.getResources(request);
        String edit = HTMLEncoder.decode((String)messages.getMessage(locale, "label.edit"));
        String delete = HTMLEncoder.decode((String)messages.getMessage(locale, "label.delete"));
        if (edit.equals(buttonAction)) {
            request.getSession().setAttribute("selectedCoverage", (Object)cvConfig);
            user.setCoverageConfig(cvConfig);
            return mapping.findForward("config.data.coverage.editor");
        }
        if (delete.equals(buttonAction)) {
            String group = this.coverageInGroup(dataConfig, selectedCoverage);
            if (group != null) {
                ActionErrors errors = new ActionErrors();
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.delete.layer.in.group", (Object)selectedCoverage, (Object)group));
                this.saveErrors(request, errors);
            } else {
                dataConfig.removeCoverage(selectedCoverage);
                request.getSession().removeAttribute("selectedCoverage");
                this.getApplicationState().notifyConfigChanged();
            }
            return mapping.findForward("config.data.coverage");
        }
        throw new ServletException("Action must be a MessageResource key value of either 'label.edit' or 'label.delete'");
    }

    private String coverageInGroup(DataConfig dataConfig, String selectedCoverage) {
        CoverageConfig cv = dataConfig.getCoverageConfig(selectedCoverage);
        String name = cv.getName();
        CoverageStoreConfig cs = dataConfig.getDataFormat(cv.getFormatId());
        NameSpaceConfig ns = dataConfig.getNameSpace(cs.getNameSpaceId());
        String qualifiedName = ns.getPrefix() + ":" + name;
        WMSConfig config = this.getWMSConfig();
        for (String group : config.getBaseMapLayers().keySet()) {
            String layers = (String)config.getBaseMapLayers().get(group);
            String[] layerNames = layers.split(",");
            for (int i = 0; i < layerNames.length; ++i) {
                if (!layerNames[i].equals(name) && !layerNames[i].equals(qualifiedName)) continue;
                return group;
            }
        }
        return null;
    }
}

