/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.CoverageConfig;
import org.vfny.geoserver.config.CoverageStoreConfig;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.form.data.CoverageStoresSelectForm;
import org.vfny.geoserver.global.UserContainer;

public final class CoverageStoresSelectAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm incomingForm, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        CoverageStoresSelectForm form = (CoverageStoresSelectForm)incomingForm;
        String buttonAction = form.getButtonAction();
        DataConfig dataConfig = this.getDataConfig();
        CoverageStoreConfig dfConfig = null;
        Locale locale = request.getLocale();
        MessageResources messages = this.getResources(request);
        String editLabel = HTMLEncoder.decode((String)messages.getMessage(locale, "label.edit"));
        String deleteLabel = HTMLEncoder.decode((String)messages.getMessage(locale, "label.delete"));
        String selectedDataFormat = form.getSelectedDataFormatId();
        if (editLabel.equals(buttonAction)) {
            dfConfig = dataConfig.getDataFormat(selectedDataFormat);
            this.getUserContainer(request).setDataFormatConfig(dfConfig);
            return mapping.findForward("config.data.format.editor");
        }
        if (deleteLabel.equals(buttonAction)) {
            int count = this.countCoveragesUsingStore(dataConfig, selectedDataFormat);
            if (count > 0) {
                ActionErrors errors = new ActionErrors();
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.delete.coverage.dataset", (Object)selectedDataFormat));
                this.saveErrors(request, errors);
            } else {
                dataConfig.removeDataFormat(selectedDataFormat);
                this.getUserContainer(request).setDataFormatConfig(null);
            }
            form.reset(mapping, request);
            return mapping.findForward("config.data.format");
        }
        throw new ServletException(new StringBuffer("Action '").append(buttonAction).append("'must be '").append(editLabel).append("' or '").append(deleteLabel).append("'").toString());
    }

    private int countCoveragesUsingStore(DataConfig dataConfig, String selectedDataFormat) {
        int count = 0;
        for (CoverageConfig coverage : dataConfig.getCoverages().values()) {
            if (!selectedDataFormat.equals(coverage.getFormatId())) continue;
            ++count;
        }
        return count;
    }
}

