/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.geoserver.catalog.Catalog;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.action.data.DataCoveragesNewAction;
import org.vfny.geoserver.config.CoverageConfig;
import org.vfny.geoserver.config.CoverageStoreConfig;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.form.data.CoverageStoresEditorForm;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.CoverageStoreInfo;
import org.vfny.geoserver.global.UserContainer;

public final class CoverageStoresEditorAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws ConfigurationException, IOException, ServletException {
        CoverageStoresEditorForm dataFormatsForm = (CoverageStoresEditorForm)form;
        String dataFormatID = dataFormatsForm.getDataFormatId();
        String namespace = dataFormatsForm.getNamespaceId();
        String type = dataFormatsForm.getType();
        String url = dataFormatsForm.getUrl();
        String description = dataFormatsForm.getDescription();
        DataConfig dataConfig = this.getDataConfig();
        CoverageStoreConfig config = null;
        config = dataConfig.getDataFormat(dataFormatID);
        boolean newCoverageFlag = false;
        if (config == null) {
            dataConfig.addDataFormat(this.getUserContainer(request).getDataFormatConfig());
            config = dataConfig.getDataFormat(dataFormatID);
            newCoverageFlag = true;
        }
        boolean enabled = dataFormatsForm.isEnabled();
        if (!dataFormatsForm.isEnabledChecked()) {
            enabled = false;
        }
        config.setEnabled(enabled);
        config.setNameSpaceId(namespace);
        config.setType(type);
        config.setUrl(url);
        config.setAbstract(description);
        dataConfig.addDataFormat(config);
        this.getUserContainer(request).setDataFormatConfig(null);
        this.getApplicationState().notifyConfigChanged();
        CoverageStoreInfo cvStoreInfo = new CoverageStoreInfo(this.getCatalog().getFactory().createCoverageStore(), this.getCatalog());
        cvStoreInfo.load(config.toDTO());
        if (newCoverageFlag) {
            CoverageConfig coverageConfig = DataCoveragesNewAction.newCoverageConfig((CoverageStoreInfo)cvStoreInfo, (String)dataFormatID, (HttpServletRequest)request, (Catalog)this.getCatalog());
            user.setCoverageConfig(coverageConfig);
            return mapping.findForward("config.data.coverage.editor");
        }
        return mapping.findForward("config.data.format");
    }

    public void dump(String msg, Map params) {
        if (msg != null) {
            System.out.print(msg + " ");
        }
        System.out.print(": { ");
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            System.out.print(entry.getKey());
            System.out.print("=");
            this.dump(entry.getValue());
            if (!i.hasNext()) continue;
            System.out.print(", ");
        }
        System.out.println("}");
    }

    public void dump(Object obj) {
        if (obj == null) {
            System.out.print("null");
        } else if (obj instanceof String) {
            System.out.print("\"");
            System.out.print(obj);
            System.out.print("\"");
        } else {
            System.out.print(obj);
        }
    }

    public void dump(String msg, Object[] array) {
        if (msg != null) {
            System.out.print(msg + " ");
        }
        System.out.print(": ");
        if (array == null) {
            System.out.print("null");
            return;
        }
        System.out.print("(");
        for (int i = 0; i < array.length; ++i) {
            this.dump(array[i]);
            if (i >= array.length - 1) continue;
            System.out.print(", ");
        }
        System.out.println(")");
    }
}

