/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses.coverage;

import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.geoserver.platform.ServiceException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.wcs.responses.CoverageResponseDelegate;

public class DebugCoverageResponseDelegate
implements CoverageResponseDelegate {
    private static final Set<String> FORMATS = new HashSet<String>(Arrays.asList("text/debug"));
    private GridCoverage2D coverage;

    public boolean canProduce(String outputFormat) {
        return outputFormat != null && (outputFormat.equalsIgnoreCase("DEBUG") || FORMATS.contains(outputFormat.toLowerCase()));
    }

    public String getContentDisposition() {
        return null;
    }

    public String getContentEncoding() {
        return null;
    }

    public String getContentType(GeoServer gs) {
        return "text/plain";
    }

    public String getFileExtension() {
        return "txt";
    }

    public String getMimeFormatFor(String outputFormat) {
        if (this.canProduce(outputFormat)) {
            return "text/debug";
        }
        return null;
    }

    public void prepare(String outputFormat, GridCoverage2D coverage) throws IOException {
        this.coverage = coverage;
    }

    public void encode(OutputStream output) throws ServiceException, IOException {
        PrintStream ps = new PrintStream(output);
        ps.println("Grid bounds: " + this.coverage.getEnvelope());
        ps.println("Grid CRS: " + this.coverage.getCoordinateReferenceSystem());
        ps.println("Grid range: " + this.coverage.getGridGeometry().getGridRange());
        ps.println("Grid to world: " + this.coverage.getGridGeometry().getGridToCRS());
        ps.println("Contents:");
        RenderedImage ri = this.coverage.getRenderedImage();
        Raster raster = ri.getData();
        for (int band = 0; band < raster.getNumBands(); ++band) {
            ps.println("Band " + band + ":");
            for (int j = raster.getMinY(); j < raster.getMinY() + raster.getHeight(); ++j) {
                for (int i = raster.getMinX(); i < raster.getMinX() + raster.getWidth(); ++i) {
                    if (raster.getTransferType() == 5) {
                        ps.print(raster.getSampleDouble(i, j, band));
                    } else if (raster.getTransferType() == 4) {
                        ps.print(raster.getSampleFloat(i, j, band));
                    } else {
                        ps.print(raster.getSample(i, j, band));
                    }
                    if (i < raster.getMinX() + raster.getWidth() - 1) {
                        // empty if block
                    }
                    ps.print(" ");
                }
                ps.println();
            }
        }
        ps.flush();
    }
}

