/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.servlets;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.servlets.Dispatcher;
import org.vfny.geoserver.util.requests.EncodingInfo;
import org.vfny.geoserver.util.requests.XmlCharsetDetector;
import org.vfny.geoserver.util.requests.readers.DispatcherKvpReader;
import org.vfny.geoserver.util.requests.readers.DispatcherXmlReader;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wcs.WcsException;

public class WcsDispatcher
extends Dispatcher {
    private static final long serialVersionUID = 3977857384599203894L;
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.servlets.wcs");
    private static int sequence = 123;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String ENCODING_HEADER_ARG = "Content-Type";
    private static final Pattern ENCODING_PATTERN = Pattern.compile("encoding\\s*\\=\\s*\"([^\"]+)\"");
    private File temp;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int targetRequest = 0;
        try {
            BufferedReader requestReader;
            BufferedReader disReader;
            int c;
            BufferedInputStream is = new BufferedInputStream((InputStream)request.getInputStream());
            this.temp = File.createTempFile("wcsdispatch" + ++sequence, "tmp");
            FileOutputStream fos = new FileOutputStream(this.temp);
            BufferedOutputStream out = new BufferedOutputStream(fos);
            while (-1 != (c = ((InputStream)is).read())) {
                out.write(c);
            }
            ((InputStream)is).close();
            out.flush();
            out.close();
            EncodingInfo encInfo = new EncodingInfo();
            try {
                disReader = new BufferedReader(XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(this.temp), (EncodingInfo)encInfo));
                requestReader = new BufferedReader(XmlCharsetDetector.createReader((InputStream)new FileInputStream(this.temp), (EncodingInfo)encInfo));
            }
            catch (Exception e) {
                throw new WcsException(e);
            }
            if (disReader != null) {
                DispatcherXmlReader requestTypeAnalyzer = new DispatcherXmlReader();
                try {
                    requestTypeAnalyzer.read((Reader)disReader, request);
                }
                catch (ServiceException e) {
                    throw new WcsException(e);
                }
            } else {
                targetRequest = -1;
            }
            LOGGER.fine("post got request " + targetRequest);
            this.doResponse(requestReader, request, response, targetRequest);
        }
        catch (ServiceException wcs) {
            HttpSession session = request.getSession();
            ServletContext context = session.getServletContext();
            GeoServer geoServer = (GeoServer)context.getAttribute("GeoServer");
            String tempResponse = ((WcsException)wcs).getXmlResponse(geoServer.isVerboseExceptions(), request, geoServer);
            response.setContentType(geoServer.getCharSet().toString());
            response.getWriter().write(tempResponse);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int targetRequest = 0;
        String queryString = request.getQueryString();
        if (queryString != null) {
            Map kvPairs = KvpRequestReader.parseKvpSet((String)queryString);
            targetRequest = DispatcherKvpReader.getRequestType((Map)kvPairs);
        } else {
            targetRequest = -1;
        }
        this.doResponse(null, request, response, targetRequest);
    }

    protected void doResponse(Reader requestReader, HttpServletRequest request, HttpServletResponse response, int req_type) throws ServletException, IOException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("req_type is " + req_type);
        }
    }
}

