/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import org.vfny.geoserver.global.Config;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.dto.ServiceDTO;
import org.vfny.geoserver.global.dto.WCSDTO;

public final class WCS
extends Service {
    public static final String WEB_CONTAINER_KEY = "WCS";
    private static final String[] EXCEPTION_FORMATS = new String[]{"application/vnd.ogc.se_xml", "application/vnd.ogc.se_inimage", "application/vnd.ogc.se_blank"};
    private boolean gmlPrefixing;

    public WCS(WCSDTO config) {
        super(config.getService());
        this.gmlPrefixing = config.isGmlPrefixing();
    }

    public WCS(Config config, Data data, GeoServer geoServer) throws ConfigurationException {
        this(config.getXMLReader().getWcs());
        this.setData(data);
        this.setGeoServer(geoServer);
    }

    WCS() {
        super(new ServiceDTO());
    }

    public void load(WCSDTO config) {
        super.load(config.getService());
        this.gmlPrefixing = config.isGmlPrefixing();
    }

    public Object toDTO() {
        WCSDTO dto = new WCSDTO();
        dto.setService((ServiceDTO)super.toDTO());
        dto.setGmlPrefixing(this.gmlPrefixing);
        return dto;
    }

    public boolean isGmlPrefixing() {
        return this.gmlPrefixing;
    }

    public void setGmlPrefixing(boolean b) {
        this.gmlPrefixing = b;
    }

    public String[] getExceptionFormats() {
        return EXCEPTION_FORMATS;
    }
}

