/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.requests;

import com.vividsolutions.jts.geom.Envelope;
import java.util.Map;
import java.util.logging.Logger;
import org.vfny.geoserver.wcs.requests.WCSRequest;
import org.vfny.geoserver.wcs.servlets.WCService;

public class CoverageRequest
extends WCSRequest {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests");
    protected String coverage = null;
    protected String outputFormat = null;
    protected String CRS = null;
    protected String ResponseCRS = null;
    protected Envelope envelope = null;
    protected String interpolation = null;
    protected String handle = null;
    protected String coverageVersion = null;
    private int gridDimension;
    private Double[] gridLow;
    private Double[] gridHigh;
    private Double[] gridOrigin;
    private Map parameters;

    public CoverageRequest(WCService service) {
        super("GetCoverage", service);
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setCoverageVersion(String version) {
        this.version = version;
    }

    public String getCoverageVersion() {
        return this.version;
    }

    public String toString() {
        StringBuffer returnString = new StringBuffer("\nRequest");
        returnString.append(": ").append(this.handle);
        returnString.append("\n coverage:").append(this.coverage);
        returnString.append("\n output format:").append(this.outputFormat);
        returnString.append("\n version:").append(this.version);
        returnString.append("\n envelope:").append(this.envelope);
        returnString.append("\n interpolation:").append(this.interpolation);
        return returnString.toString();
    }

    public boolean equals(Object obj) {
        super.equals(obj);
        if (!(obj instanceof CoverageRequest)) {
            return false;
        }
        CoverageRequest request = (CoverageRequest)((Object)obj);
        boolean isEqual = true;
        isEqual = this.coverage == null && request.getCoverage() == null ? isEqual : (this.coverage == null || request.getCoverage() == null ? false : (request.getCoverage().equals(this.coverage) ? isEqual : false));
        isEqual = this.version == null && request.getVersion() == null ? isEqual : (this.version == null || request.getVersion() == null ? false : (request.getVersion().equals(this.version) ? isEqual : false));
        isEqual = this.handle == null && request.getHandle() == null ? isEqual : (this.handle == null || request.getHandle() == null ? false : (request.getHandle().equals(this.handle) ? isEqual : false));
        isEqual = this.outputFormat == null && request.getOutputFormat() == null ? isEqual : (this.outputFormat == null || request.getOutputFormat() == null ? false : (request.getOutputFormat().equals(this.outputFormat) ? isEqual : false));
        isEqual = this.envelope == null && request.getEnvelope() == null ? isEqual : (this.envelope == null || request.getEnvelope() == null ? false : (request.getEnvelope().equals((Object)this.envelope) ? isEqual : false));
        isEqual = this.interpolation == null && request.getInterpolation() == null ? isEqual : (this.interpolation == null || request.getInterpolation() == null ? false : (request.getInterpolation().equals(this.interpolation) ? isEqual : false));
        return isEqual;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 23 * result + (this.handle == null ? 0 : this.handle.hashCode());
        result = 23 * result + (this.coverage == null ? 0 : this.coverage.hashCode());
        return result;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(Envelope envelope) {
        this.envelope = envelope;
    }

    public void setEnvelope(String envelope) {
        String[] coords = envelope.split(",");
        try {
            double arg0 = Double.parseDouble(coords[0]);
            double arg1 = Double.parseDouble(coords[1]);
            double arg2 = Double.parseDouble(coords[2]);
            double arg3 = Double.parseDouble(coords[3]);
            this.envelope = new Envelope(arg0, arg2, arg1, arg3);
        }
        catch (NumberFormatException e) {
            this.envelope = null;
        }
    }

    public String getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(String interpolation) {
        this.interpolation = interpolation;
    }

    public String getCoverage() {
        return this.coverage;
    }

    public void setCoverage(String coverage) {
        this.coverage = coverage;
    }

    public int getGridDimension() {
        return this.gridDimension;
    }

    public void setGridDimension(int gridDimension) {
        this.gridDimension = gridDimension;
    }

    public void setGridDimension(String value) {
        this.gridDimension = Integer.parseInt(value);
    }

    public void setOffsetVector(Double[] offsetVector) {
        if (this.envelope != null) {
            double envWidth = Math.abs(this.envelope.getMaxX() - this.envelope.getMinX());
            double envHeight = Math.abs(this.envelope.getMaxY() - this.envelope.getMinY());
            double width = envWidth / Math.abs(offsetVector[0]);
            double height = envHeight / Math.abs(offsetVector[1]);
            this.setGridOrigin(new Double[]{new Double(0.0), new Double(0.0)});
            this.setGridLow(new Double[]{new Double(0.0), new Double(0.0)});
            this.setGridHigh(new Double[]{new Double(width), new Double(height)});
        }
    }

    public void setGridOrigin(Double[] origin) {
        this.gridOrigin = origin;
    }

    public void setGridHigh(Double[] highers) {
        this.gridHigh = highers;
    }

    public void setGridLow(Double[] lowers) {
        this.gridLow = lowers;
    }

    public Double[] getGridHigh() {
        return this.gridHigh;
    }

    public Double[] getGridLow() {
        return this.gridLow;
    }

    public Double[] getGridOrigin() {
        return this.gridOrigin;
    }

    public String getCRS() {
        return this.CRS;
    }

    public void setCRS(String crs) {
        this.CRS = crs;
    }

    public String getResponseCRS() {
        return this.ResponseCRS;
    }

    public void setResponseCRS(String responseCRS) {
        this.ResponseCRS = responseCRS;
    }

    public void setParameters(Map kvpPairs) {
        this.parameters = kvpPairs;
    }

    public Map getParameters() {
        return this.parameters;
    }
}

