/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.requests;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.wcs.requests.CoverageRequest;
import org.vfny.geoserver.wcs.servlets.WCService;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class CoverageHandler
extends XMLFilterImpl
implements ContentHandler {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.requests.wcs");
    private WCService service = null;
    private CoverageRequest request = null;
    private String currentTag = new String();
    private Double[] coordinates = new Double[4];
    private Double[] lowers = new Double[2];
    private Double[] highers = new Double[2];
    private Double[] origin = new Double[2];
    private Double[] offsetVector = new Double[2];
    private boolean insideEnvelope = false;
    private boolean insideGrid = false;
    private boolean insideRange = false;
    private int paramNum = -1;
    private ArrayList paramNames = new ArrayList();
    private HashMap params = new HashMap();
    private int minTmp;

    public CoverageHandler(WCService service) {
        this.service = service;
        this.request = new CoverageRequest(service);
    }

    public CoverageRequest getRequest(HttpServletRequest req) {
        this.request.setHttpServletRequest(req);
        return this.request;
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        block7: {
            block10: {
                block9: {
                    block8: {
                        block6: {
                            if (LOGGER.isLoggable(Level.FINEST)) {
                                LOGGER.finest("at start element: " + localName);
                            }
                            this.currentTag = localName;
                            if (!this.currentTag.equals("GetCoverage")) break block6;
                            int length = atts.getLength();
                            for (int i = 0; i < length; ++i) {
                                String curAtt = atts.getLocalName(i);
                                if (curAtt.equals("service")) {
                                    this.request.setService(atts.getValue(i));
                                    continue;
                                }
                                if (!curAtt.equals("version")) continue;
                                this.request.setVersion(atts.getValue(i));
                            }
                            break block7;
                        }
                        if (!this.currentTag.equals("Envelope")) break block8;
                        this.insideEnvelope = true;
                        int length = atts.getLength();
                        for (int i = 0; i < length; ++i) {
                            String curAtt = atts.getLocalName(i);
                            if (!curAtt.equals("srsName")) continue;
                            this.request.setCRS(atts.getValue(i));
                            if (this.request.getResponseCRS() != null) continue;
                            this.request.setResponseCRS(atts.getValue(i));
                        }
                        break block7;
                    }
                    if (!this.currentTag.equals("Grid") && !this.currentTag.equals("RectifiedGrid")) break block9;
                    this.insideGrid = true;
                    int length = atts.getLength();
                    for (int i = 0; i < length; ++i) {
                        String curAtt = atts.getLocalName(i);
                        if (!curAtt.equals("dimension")) continue;
                        this.request.setGridDimension(atts.getValue(i));
                    }
                    break block7;
                }
                if (!this.currentTag.equals("rangeSubset")) break block10;
                this.insideRange = true;
                break block7;
            }
            if (!this.currentTag.equals("axisSubset") || !this.insideRange) break block7;
            int length = atts.getLength();
            for (int i = 0; i < length; ++i) {
                String curAtt = atts.getLocalName(i);
                if (!curAtt.equals("name")) continue;
                this.paramNames.add(atts.getValue(i));
                ++this.paramNum;
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        LOGGER.finer("at end element: " + localName);
        this.currentTag = localName;
        if (this.currentTag.equals("Envelope")) {
            this.insideEnvelope = false;
        } else if (this.currentTag.equals("Grid") || this.currentTag.equals("RectifiedGrid")) {
            this.insideGrid = false;
        } else if (this.currentTag.equals("rangeSubset")) {
            this.insideRange = false;
            this.request.setParameters(this.params);
        }
        this.currentTag = "";
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        block57: {
            String s = new String(ch, start, length);
            if (this.currentTag.equals("sourceCoverage")) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("found Coverage name: " + s);
                }
                this.request.setCoverage(s);
            } else if (this.currentTag.equals("interpolationMethod")) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("found Interpolation Method: " + s);
                }
                this.request.setInterpolation(s);
            } else if (this.currentTag.equals("crs")) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("found Output CRS: " + s);
                }
                this.request.setCRS(s);
                if (this.request.getResponseCRS() == null) {
                    this.request.setResponseCRS(s);
                }
            } else if (this.currentTag.equals("responseCrs")) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("found Output CRS: " + s);
                }
                this.request.setResponseCRS(s);
            } else if (this.currentTag.equals("format")) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("found Output Format: " + s);
                }
                this.request.setOutputFormat(s);
            } else if (this.currentTag.equals("pos") && this.insideEnvelope) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("found Envelope Coordinates: " + s);
                }
                if (this.coordinates[0] == null) {
                    String[] coords = s.split(" ");
                    try {
                        double arg0 = Double.parseDouble(coords[0]);
                        double arg1 = Double.parseDouble(coords[1]);
                        this.coordinates[0] = new Double(arg0);
                        this.coordinates[1] = new Double(arg1);
                    }
                    catch (NumberFormatException e) {
                        this.coordinates[0] = null;
                        this.coordinates[1] = null;
                    }
                } else if (this.coordinates[2] == null) {
                    String[] coords = s.split(" ");
                    try {
                        double arg0 = Double.parseDouble(coords[0]);
                        double arg1 = Double.parseDouble(coords[1]);
                        this.coordinates[2] = new Double(arg0);
                        this.coordinates[3] = new Double(arg1);
                        Envelope env = new Envelope(this.coordinates[0].doubleValue(), this.coordinates[2].doubleValue(), this.coordinates[1].doubleValue(), this.coordinates[3].doubleValue());
                        this.request.setEnvelope(env);
                    }
                    catch (NumberFormatException e) {
                        this.coordinates[2] = null;
                        this.coordinates[3] = null;
                    }
                }
            } else if (this.currentTag.equals("low") && this.insideGrid) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("found Grid Lowers: " + s);
                }
                String[] coords = s.split(" ");
                try {
                    double arg0 = Double.parseDouble(coords[0]);
                    double arg1 = Double.parseDouble(coords[1]);
                    this.lowers[0] = new Double(arg0);
                    this.lowers[1] = new Double(arg1);
                    this.request.setGridLow(this.lowers);
                }
                catch (NumberFormatException e) {
                    this.lowers[0] = null;
                    this.lowers[1] = null;
                }
            } else if (this.currentTag.equals("high") && this.insideGrid) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("found Grid Highers: " + s);
                }
                String[] coords = s.split(" ");
                try {
                    double arg0 = Double.parseDouble(coords[0]);
                    double arg1 = Double.parseDouble(coords[1]);
                    this.highers[0] = new Double(arg0);
                    this.highers[1] = new Double(arg1);
                    this.request.setGridHigh(this.highers);
                }
                catch (NumberFormatException e) {
                    this.highers[0] = null;
                    this.highers[1] = null;
                }
            } else if (this.currentTag.equals("pos") && this.insideGrid) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("found Grid Origin: " + s);
                }
                String[] coords = s.split(" ");
                try {
                    double arg0 = Double.parseDouble(coords[0]);
                    double arg1 = Double.parseDouble(coords[1]);
                    this.origin[0] = new Double(arg0);
                    this.origin[1] = new Double(arg1);
                    this.request.setGridOrigin(this.origin);
                }
                catch (NumberFormatException e) {
                    this.origin[0] = null;
                    this.origin[1] = null;
                }
            } else if (this.currentTag.equals("offsetVector") && this.insideGrid) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("found Grid Offset-Vector: " + s);
                }
                String[] coords = s.split(" ");
                try {
                    double arg0 = Double.parseDouble(coords[0]);
                    double arg1 = Double.parseDouble(coords[1]);
                    if (this.offsetVector[0] == null) {
                        this.offsetVector[0] = new Double(arg0);
                        break block57;
                    }
                    this.offsetVector[1] = new Double(arg1);
                    this.request.setOffsetVector(this.offsetVector);
                }
                catch (NumberFormatException e) {
                    this.offsetVector[0] = null;
                    this.offsetVector[1] = null;
                }
            } else if (this.currentTag.equals("singleValue") && this.insideRange && this.paramNum == this.paramNames.size() - 1) {
                String key;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("found axisSubset{" + this.paramNames.get(this.paramNum) + "} > singleValue: " + s);
                }
                if (this.params.get(key = (String)this.paramNames.get(this.paramNum)) == null) {
                    this.params.put(key, s);
                }
            } else if (this.currentTag.equals("min") && this.insideRange && this.paramNum == this.paramNames.size() - 1) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("found axisSubset{" + this.paramNames.get(this.paramNum) + "} > min: " + s);
                }
                this.minTmp = (int)Math.round(Double.parseDouble(s));
            } else if (this.currentTag.equals("max") && this.insideRange && this.paramNum == this.paramNames.size() - 1) {
                String key;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("found axisSubset{" + this.paramNames.get(this.paramNum) + "} > max: " + s);
                }
                if (this.params.get(key = (String)this.paramNames.get(this.paramNum)) == null) {
                    int maxTmp = (int)Math.round(Double.parseDouble(s));
                    this.params.put(key, this.minTmp + "/" + maxTmp);
                    this.minTmp = 0;
                }
            }
        }
        this.currentTag = "";
    }
}

