/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs;

import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.util.Requests;

public class WcsException
extends ServiceException {
    private static Logger LOGGER = Logger.getLogger("org.vfny.geoserver.wcs");
    private static final String SE_XML = "application/vnd.ogc.se_xml";

    public WcsException() {
    }

    public WcsException(String message) {
        super(message);
    }

    public WcsException(Throwable e) {
        super(e);
    }

    public WcsException(String message, String locator) {
        super(message, locator);
    }

    public WcsException(String message, Throwable cause) {
        super(message, cause);
    }

    public WcsException(Throwable e, String preMessage, String locator) {
        super(e, preMessage, locator);
    }

    public String getXmlResponse(boolean printStackTrace, HttpServletRequest request, GeoServer geoserver) {
        LOGGER.warning("encountered error: " + ((Throwable)((Object)this)).getMessage());
        String indent = "   ";
        StringBuffer returnXml = new StringBuffer("<?xml version=\"1.0\" ?>\n");
        returnXml.append("<ServiceExceptionReport\n");
        returnXml.append(indent + "version=\"1.2.0\"\n");
        returnXml.append(indent + "xmlns=\"http://www.opengis.net/ogc\"\n");
        returnXml.append(indent + "xmlns:xsi=\"http://www.w3.org/2001/" + "XMLSchema-instance\"\n");
        returnXml.append(indent);
        returnXml.append("xsi:schemaLocation=\"http://www.opengis.net/ogc ");
        returnXml.append(Requests.getSchemaBaseUrl((HttpServletRequest)request, (GeoServer)geoserver) + "wcs/1.0.0/OGC-exception.xsd\">\n");
        returnXml.append(indent + "<ServiceException");
        if (!this.isEmpty(this.getCode())) {
            returnXml.append(" code=\"" + this.getCode() + "\"");
        }
        if (!this.isEmpty(this.locator)) {
            returnXml.append(" locator=\"" + this.locator + "\"");
        }
        returnXml.append(">\n" + indent + indent);
        returnXml.append(this.getXmlMessage(printStackTrace));
        returnXml.append(indent + "</ServiceException>\n");
        returnXml.append("</ServiceExceptionReport>");
        LOGGER.fine("return wfs exception is " + returnXml);
        return returnXml.toString();
    }

    public String getMimeType(GeoServer geoserver) {
        return "application/vnd.ogc.se_xml; charset=" + geoserver.getCharSet().name();
    }
}

