/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.ArrayList;
import java.util.List;
import org.geotools.util.SoftValueHashMap;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class GeoServerExtensions
implements ApplicationContextAware,
ApplicationListener {
    static SoftValueHashMap extensionsCache = new SoftValueHashMap(40);
    static ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        GeoServerExtensions.context = context;
        extensionsCache.clear();
    }

    public static final List extensions(Class extensionPoint, ApplicationContext context) {
        ArrayList result = (ArrayList)extensionsCache.get((Object)extensionPoint);
        if (result == null) {
            result = new ArrayList(context.getBeansOfType(extensionPoint).values());
            extensionsCache.put((Object)extensionPoint, result);
        }
        return new ArrayList(result);
    }

    public static final List extensions(Class extensionPoint) {
        return GeoServerExtensions.extensions(extensionPoint, context);
    }

    public static final Object bean(String name) {
        return context.getBean(name);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            extensionsCache.clear();
        }
    }
}

