/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class GeoServerResourceLoader
extends DefaultResourceLoader {
    Set searchLocations = new TreeSet();
    File baseDirectory;

    public GeoServerResourceLoader() {
    }

    public GeoServerResourceLoader(File baseDirectory) {
        this();
        this.baseDirectory = baseDirectory;
        this.searchLocations.add(baseDirectory);
    }

    public void addSearchLocation(File searchLocation) {
        this.searchLocations.add(searchLocation);
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public File find(String location) throws IOException {
        File file = new File(location);
        if (file.isAbsolute()) {
            return file;
        }
        Iterator f = this.searchLocations.iterator();
        while (f.hasNext()) {
            File base = (File)f.next();
            file = new File(base, location);
            if (!file.exists()) continue;
            return file;
        }
        Resource resource = this.getResource(location);
        if (resource.exists()) {
            return resource.getFile();
        }
        return null;
    }

    public File createDirectory(String location) throws IOException {
        File file = this.find(location);
        if (file != null && !file.isDirectory()) {
            String msg = location + " already exists and is not directory";
            throw new IOException(msg);
        }
        file = new File(location);
        if (file.isAbsolute()) {
            file.mkdir();
            return file;
        }
        if (this.baseDirectory == null) {
            return null;
        }
        file = new File(this.baseDirectory, location);
        file.mkdir();
        return file;
    }

    public File createFile(String location) throws IOException {
        File file = this.find(location);
        if (file != null) {
            return file;
        }
        file = new File(location);
        if (file.isAbsolute()) {
            file.createNewFile();
            return file;
        }
        if (this.baseDirectory == null) {
            return null;
        }
        file = new File(this.baseDirectory, location);
        file.createNewFile();
        return file;
    }
}

