/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.geoserver.GeoServerResourceLoader;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.propertyeditors.ByteArrayPropertyEditor;
import org.springframework.beans.propertyeditors.CharacterEditor;
import org.springframework.beans.propertyeditors.ClassEditor;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.CustomCollectionEditor;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.beans.propertyeditors.FileEditor;
import org.springframework.beans.propertyeditors.InputStreamEditor;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.beans.propertyeditors.PropertiesEditor;
import org.springframework.beans.propertyeditors.StringArrayPropertyEditor;
import org.springframework.beans.propertyeditors.URLEditor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BeanPersister
implements BeanFactoryPostProcessor,
ApplicationListener {
    static Map editors = new HashMap();
    Logger logger = Logger.getLogger(this.getClass().getName());
    GeoServerResourceLoader loader;
    List beans;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$util$Locale;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class array$Lorg$springframework$core$io$Resource;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;
    static /* synthetic */ Class class$java$util$SortedSet;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public BeanPersister(GeoServerResourceLoader loader) {
        this.loader = loader;
        this.beans = new ArrayList();
    }

    public void setBeans(List beans) {
        this.beans = beans;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        try {
            File services = this.loader.find("services");
            if (services == null) {
                return;
            }
            if (services.isDirectory()) {
                Iterator b = this.beans.iterator();
                while (b.hasNext()) {
                    String bean = (String)b.next();
                    this.loadBean(bean, beanFactory);
                }
            }
        }
        catch (IOException e) {
            String msg = "Error loading services";
            throw new BeanInitializationException(msg, (Throwable)e);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextClosedEvent) {
            ApplicationContext context = (ApplicationContext)event.getSource();
            Iterator b = this.beans.iterator();
            while (b.hasNext()) {
                String beanId = (String)b.next();
                Object bean = context.getBean(beanId);
                if (bean != null) {
                    this.saveBean(beanId, bean, context);
                    continue;
                }
                this.logger.warning("Could not locate " + beanId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void saveBean(String id, Object bean, ApplicationContext context) {
        OutputStream os = null;
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = builder.newDocument();
        Element root = doc.createElement("bean");
        root.setAttribute("id", id);
        doc.appendChild(root);
        Method[] methods = bean.getClass().getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method setter;
            String propName;
            Method method = methods[i];
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0 || method.getReturnType() == null || "".equals(propName = method.getName().substring(3)) || (setter = bean.getClass().getMethod("set" + propName, method.getReturnType())) == null) continue;
            propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
            Class<?> type = method.getReturnType();
            PropertyEditor editor = this.editor(type);
            if (editor != null) {
                editor.setValue(method.invoke(bean, null));
                String text = editor.getAsText();
                Element propElement = doc.createElement("property");
                propElement.setAttribute("name", propName);
                propElement.setAttribute("value", text);
                propElement.setAttribute("type", type.getName());
                root.appendChild(propElement);
                continue;
            }
            String msg = "Could not find editor for bean=" + id + ", property=" + propName;
            this.logger.warning(msg);
        }
        Transformer tx = TransformerFactory.newInstance().newTransformer();
        DOMSource source = new DOMSource(root);
        File services = this.loader.createDirectory("services");
        os = new BufferedOutputStream(new FileOutputStream(new File(services, id + ".xml")));
        StreamResult result = new StreamResult(os);
        tx.transform(source, result);
        os.close();
        Object var18_20 = null;
        if (os == null) return;
        try {
            os.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (Exception e) {
                String msg = "Error persisting bean: " + id;
                this.logger.log(Level.WARNING, msg, e);
                Object var18_21 = null;
                if (os == null) return;
                try {
                    os.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    void loadBean(String id, ConfigurableListableBeanFactory factory) {
        try {
            File xml = this.loader.find("services" + File.separator + id + ".xml");
            if (xml == null) {
                this.logger.warning("Could not persistance file for bean: " + id);
                return;
            }
            BeanDefinition beanDef = factory.getBeanDefinition(id);
            if (beanDef == null) {
                this.logger.warning("Could not find bean definition for: " + id);
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(xml);
            NodeList propList = doc.getElementsByTagName("property");
            for (int i = 0; i < propList.getLength(); ++i) {
                Element propElement = (Element)propList.item(i);
                String name = propElement.getAttribute("name");
                String valu = propElement.getAttribute("value");
                String type = propElement.getAttribute("type");
                Class<?> clazz = Class.forName(type);
                beanDef.getPropertyValues().removePropertyValue(name);
                beanDef.getPropertyValues().addPropertyValue(name, (Object)new TypedStringValue(valu, clazz));
            }
        }
        catch (Exception e) {
            String msg = "Error reading bean definition for " + id;
            this.logger.log(Level.WARNING, msg, e);
        }
    }

    PropertyEditor editor(Class type) {
        if (editors.containsKey(type)) {
            return (PropertyEditor)editors.get(type);
        }
        return PropertyEditorManager.findEditor(type);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        editors.put(array$B == null ? (array$B = BeanPersister.class$("[B")) : array$B, new ByteArrayPropertyEditor());
        editors.put(class$java$lang$Class == null ? (class$java$lang$Class = BeanPersister.class$("java.lang.Class")) : class$java$lang$Class, new ClassEditor());
        editors.put(class$java$io$File == null ? (class$java$io$File = BeanPersister.class$("java.io.File")) : class$java$io$File, new FileEditor());
        editors.put(class$java$io$InputStream == null ? (class$java$io$InputStream = BeanPersister.class$("java.io.InputStream")) : class$java$io$InputStream, new InputStreamEditor());
        editors.put(class$java$util$Locale == null ? (class$java$util$Locale = BeanPersister.class$("java.util.Locale")) : class$java$util$Locale, new LocaleEditor());
        editors.put(class$java$util$Properties == null ? (class$java$util$Properties = BeanPersister.class$("java.util.Properties")) : class$java$util$Properties, new PropertiesEditor());
        editors.put(array$Lorg$springframework$core$io$Resource == null ? (array$Lorg$springframework$core$io$Resource = BeanPersister.class$("[Lorg.springframework.core.io.Resource;")) : array$Lorg$springframework$core$io$Resource, new ResourceArrayPropertyEditor());
        editors.put(array$Ljava$lang$String == null ? (array$Ljava$lang$String = BeanPersister.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, new StringArrayPropertyEditor());
        editors.put(class$java$net$URL == null ? (class$java$net$URL = BeanPersister.class$("java.net.URL")) : class$java$net$URL, new URLEditor());
        editors.put(class$java$util$Collection == null ? (class$java$util$Collection = BeanPersister.class$("java.util.Collection")) : class$java$util$Collection, new CustomCollectionEditor(class$java$util$Collection == null ? (class$java$util$Collection = BeanPersister.class$("java.util.Collection")) : class$java$util$Collection));
        editors.put(class$java$util$Set == null ? (class$java$util$Set = BeanPersister.class$("java.util.Set")) : class$java$util$Set, new CustomCollectionEditor(class$java$util$Set == null ? (class$java$util$Set = BeanPersister.class$("java.util.Set")) : class$java$util$Set));
        editors.put(class$java$util$SortedSet == null ? (class$java$util$SortedSet = BeanPersister.class$("java.util.SortedSet")) : class$java$util$SortedSet, new CustomCollectionEditor(class$java$util$SortedSet == null ? (class$java$util$SortedSet = BeanPersister.class$("java.util.SortedSet")) : class$java$util$SortedSet));
        editors.put(class$java$util$List == null ? (class$java$util$List = BeanPersister.class$("java.util.List")) : class$java$util$List, new CustomCollectionEditor(class$java$util$List == null ? (class$java$util$List = BeanPersister.class$("java.util.List")) : class$java$util$List));
        CharacterEditor characterEditor = new CharacterEditor(false);
        CustomBooleanEditor booleanEditor = new CustomBooleanEditor(false);
        editors.put(Character.TYPE, characterEditor);
        editors.put(class$java$lang$Character == null ? (class$java$lang$Character = BeanPersister.class$("java.lang.Character")) : class$java$lang$Character, characterEditor);
        editors.put(Boolean.TYPE, booleanEditor);
        editors.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = BeanPersister.class$("java.lang.Boolean")) : class$java$lang$Boolean, booleanEditor);
        CustomNumberEditor byteEditor = new CustomNumberEditor(class$java$lang$Byte == null ? (class$java$lang$Byte = BeanPersister.class$("java.lang.Byte")) : class$java$lang$Byte, false);
        CustomNumberEditor shortEditor = new CustomNumberEditor(class$java$lang$Short == null ? (class$java$lang$Short = BeanPersister.class$("java.lang.Short")) : class$java$lang$Short, false);
        CustomNumberEditor integerEditor = new CustomNumberEditor(class$java$lang$Integer == null ? (class$java$lang$Integer = BeanPersister.class$("java.lang.Integer")) : class$java$lang$Integer, false);
        CustomNumberEditor longEditor = new CustomNumberEditor(class$java$lang$Long == null ? (class$java$lang$Long = BeanPersister.class$("java.lang.Long")) : class$java$lang$Long, false);
        CustomNumberEditor floatEditor = new CustomNumberEditor(class$java$lang$Float == null ? (class$java$lang$Float = BeanPersister.class$("java.lang.Float")) : class$java$lang$Float, false);
        CustomNumberEditor doubleEditor = new CustomNumberEditor(class$java$lang$Double == null ? (class$java$lang$Double = BeanPersister.class$("java.lang.Double")) : class$java$lang$Double, false);
        editors.put(Byte.TYPE, byteEditor);
        editors.put(class$java$lang$Byte == null ? (class$java$lang$Byte = BeanPersister.class$("java.lang.Byte")) : class$java$lang$Byte, byteEditor);
        editors.put(Short.TYPE, shortEditor);
        editors.put(class$java$lang$Short == null ? (class$java$lang$Short = BeanPersister.class$("java.lang.Short")) : class$java$lang$Short, shortEditor);
        editors.put(Integer.TYPE, integerEditor);
        editors.put(class$java$lang$Integer == null ? (class$java$lang$Integer = BeanPersister.class$("java.lang.Integer")) : class$java$lang$Integer, integerEditor);
        editors.put(Long.TYPE, longEditor);
        editors.put(class$java$lang$Long == null ? (class$java$lang$Long = BeanPersister.class$("java.lang.Long")) : class$java$lang$Long, longEditor);
        editors.put(Float.TYPE, floatEditor);
        editors.put(class$java$lang$Float == null ? (class$java$lang$Float = BeanPersister.class$("java.lang.Float")) : class$java$lang$Float, floatEditor);
        editors.put(Double.TYPE, doubleEditor);
        editors.put(class$java$lang$Double == null ? (class$java$lang$Double = BeanPersister.class$("java.lang.Double")) : class$java$lang$Double, doubleEditor);
        editors.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BeanPersister.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new CustomNumberEditor(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BeanPersister.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, false));
        editors.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = BeanPersister.class$("java.math.BigInteger")) : class$java$math$BigInteger, new CustomNumberEditor(class$java$math$BigInteger == null ? (class$java$math$BigInteger = BeanPersister.class$("java.math.BigInteger")) : class$java$math$BigInteger, false));
    }
}

