/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class UCSReader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int CHAR_BUFFER_INITIAL_SIZE = 1024;
    public static final short UCS2LE = 1;
    public static final short UCS2BE = 2;
    public static final short UCS4LE = 4;
    public static final short UCS4BE = 8;
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final int MIN_CODE_POINT = 0;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    protected InputStream fInputStream;
    protected byte[] fBuffer;
    protected short fEncoding;
    protected char[] fCharBuf;
    protected int fCharCount;

    public UCSReader(InputStream inputStream, short encoding) {
        this(inputStream, 8192, encoding);
    }

    public UCSReader(InputStream inputStream, int size, short encoding) {
        this.fInputStream = inputStream;
        this.fBuffer = new byte[size];
        this.fEncoding = encoding;
        this.fCharBuf = new char[1024];
        this.fCharCount = 0;
    }

    public int read() throws IOException {
        if (0 != this.fCharCount) {
            --this.fCharCount;
            return this.fCharBuf[this.fCharCount] & 0xFFFF;
        }
        int b0 = this.fInputStream.read() & 0xFF;
        if (b0 == 255) {
            return -1;
        }
        int b1 = this.fInputStream.read() & 0xFF;
        if (b1 == 255) {
            return -1;
        }
        if (this.fEncoding >= 4) {
            int b2 = this.fInputStream.read() & 0xFF;
            if (b2 == 255) {
                return -1;
            }
            int b3 = this.fInputStream.read() & 0xFF;
            if (b3 == 255) {
                return -1;
            }
            int codepoint = 8 == this.fEncoding ? (b0 << 24) + (b1 << 16) + (b2 << 8) + b3 : (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
            if (!this.isSupplementaryCodePoint(codepoint)) {
                return codepoint;
            }
            int cp1 = codepoint - 65536 & 0xFFFFF;
            int highSurrogate = 55296 + (cp1 >>> 10);
            this.fCharBuf[this.fCharCount] = (char)(56320 + (cp1 & 0x3FF));
            return highSurrogate;
        }
        if (this.fEncoding == 2) {
            return (b0 << 8) + b1;
        }
        return (b1 << 8) + b0;
    }

    public int read(char[] ch, int offset, int length) throws IOException {
        int charsRead;
        if (0 > offset || offset > ch.length || 0 > length || offset + length > ch.length || 0 > offset + length) {
            throw new IndexOutOfBoundsException();
        }
        if (0 == length) {
            return 0;
        }
        if (this.fEncoding < 4) {
            return this.readUCS2(ch, offset, length);
        }
        for (charsRead = 0; charsRead <= length && 0 != this.fCharCount; ++charsRead) {
            ch[offset + charsRead] = this.fCharBuf[--this.fCharCount];
        }
        if (0 != length - charsRead) {
            int b2;
            int i;
            int count;
            int byteLength = length - charsRead << 2;
            if (byteLength > this.fBuffer.length) {
                byteLength = this.fBuffer.length;
            }
            if (-1 == (count = this.fInputStream.read(this.fBuffer, 0, byteLength))) {
                return 0 == charsRead ? -1 : charsRead;
            }
            int numToRead = 4 - (count & 3) & 3;
            for (int i2 = 0; i2 < numToRead; ++i2) {
                int charRead = this.fInputStream.read();
                if (charRead == -1) {
                    for (int j = i2; j < numToRead; ++j) {
                        this.fBuffer[count + j] = 0;
                    }
                    break;
                }
                this.fBuffer[count + i2] = (byte)charRead;
            }
            int numChars = (count += numToRead) >> 2;
            int curPos = 0;
            int charsCount = charsRead;
            for (i = 0; i < numChars && length >= charsCount; ++i) {
                int b0 = this.fBuffer[curPos++] & 0xFF;
                int b1 = this.fBuffer[curPos++] & 0xFF;
                b2 = this.fBuffer[curPos++] & 0xFF;
                int b3 = this.fBuffer[curPos++] & 0xFF;
                int codepoint = 8 == this.fEncoding ? (b0 << 24) + (b1 << 16) + (b2 << 8) + b3 : (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
                if (!this.isSupplementaryCodePoint(codepoint)) {
                    ch[offset + charsCount] = (char)codepoint;
                    ++charsCount;
                    continue;
                }
                if (2 > length - charsCount) break;
                int cp1 = codepoint - 65536 & 0xFFFFF;
                ch[offset + charsCount] = (char)(55296 + (cp1 >>> 10));
                ch[offset + charsCount + 1] = (char)(56320 + (cp1 & 0x3FF));
                charsCount += 2;
            }
            curPos = (numChars << 2) - 1;
            for (int k = numChars; k > i; --k) {
                int b3 = this.fBuffer[curPos--] & 0xFF;
                b2 = this.fBuffer[curPos--] & 0xFF;
                int b1 = this.fBuffer[curPos--] & 0xFF;
                int b0 = this.fBuffer[curPos--] & 0xFF;
                int codepoint = 8 == this.fEncoding ? (b0 << 24) + (b1 << 16) + (b2 << 8) + b3 : (b3 << 24) + (b2 << 16) + (b1 << 8) + b0;
                if (2 > this.fCharBuf.length - k) {
                    char[] newBuf = new char[this.fCharBuf.length << 1];
                    System.arraycopy(this.fCharBuf, 0, newBuf, 0, this.fCharBuf.length);
                    this.fCharBuf = newBuf;
                }
                if (!this.isSupplementaryCodePoint(codepoint)) {
                    this.fCharBuf[this.fCharCount++] = (char)codepoint;
                    continue;
                }
                int cp1 = codepoint - 65536 & 0xFFFFF;
                this.fCharBuf[this.fCharCount++] = (char)(56320 + ((char)cp1 & 0x3FF));
                this.fCharBuf[this.fCharCount++] = (char)(55296 + (cp1 >>> 10));
            }
            return charsCount;
        }
        return charsRead;
    }

    protected int readUCS2(char[] ch, int offset, int length) throws IOException {
        int count;
        int byteLength = length << 1;
        if (byteLength > this.fBuffer.length) {
            byteLength = this.fBuffer.length;
        }
        if ((count = this.fInputStream.read(this.fBuffer, 0, byteLength)) == -1) {
            return -1;
        }
        int numToRead = count & 1;
        if (numToRead != 0) {
            ++count;
            int charRead = this.fInputStream.read();
            this.fBuffer[count] = charRead == -1 ? (byte)0 : (byte)charRead;
        }
        int numChars = count >> 1;
        int curPos = 0;
        for (int i = 0; i < numChars; ++i) {
            int b0 = this.fBuffer[curPos++] & 0xFF;
            int b1 = this.fBuffer[curPos++] & 0xFF;
            ch[offset + i] = this.fEncoding == 2 ? (char)((b0 << 8) + b1) : (char)((b1 << 8) + b0);
        }
        return numChars;
    }

    public long skip(long n) throws IOException {
        int charWidth = this.fEncoding >= 4 ? 2 : 1;
        long bytesSkipped = this.fInputStream.skip(n << charWidth);
        if ((bytesSkipped & (long)(charWidth | 1)) == 0L) {
            return bytesSkipped >>> charWidth;
        }
        return (bytesSkipped >>> charWidth) + 1L;
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return this.fInputStream.markSupported();
    }

    public void mark(int readAheadLimit) throws IOException {
        this.fInputStream.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        this.fInputStream.reset();
    }

    public void close() throws IOException {
        this.fInputStream.close();
        this.fInputStream = null;
        this.fCharBuf = null;
        this.fBuffer = null;
    }

    public String getEncoding() {
        if (4 > this.fEncoding) {
            return "ISO-10646-UCS-2";
        }
        return "ISO-10646-UCS-4";
    }

    public String getByteOrder() {
        if (1 == this.fEncoding || 4 == this.fEncoding) {
            return "LITTLE_ENDIAN";
        }
        return "BIG_ENDIAN";
    }

    protected boolean isSupplementaryCodePoint(int codePoint) {
        return codePoint >= 65536 && codePoint <= 0x10FFFF;
    }
}

