/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.util;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;

public class RequestUtils {
    public static String schemaBaseURL(HttpServletRequest req) {
        return RequestUtils.baseURL(req) + "schemas/";
    }

    public static String baseURL(HttpServletRequest req) {
        String url = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath() + "/";
        return url;
    }

    public static String proxifiedBaseURL(String baseUrl, String proxyBase) {
        if (proxyBase == null || proxyBase.trim().length() == 0) {
            if (!baseUrl.endsWith("/")) {
                baseUrl = baseUrl + "/";
            }
            return baseUrl;
        }
        try {
            String proxifiedBaseUrl;
            URI baseUri = new URI(baseUrl);
            if (proxyBase.endsWith("/")) {
                proxyBase = proxyBase.substring(0, proxyBase.length() - 1);
            }
            if (!(proxifiedBaseUrl = proxyBase + baseUri.getPath()).endsWith("/")) {
                proxifiedBaseUrl = proxifiedBaseUrl + "/";
            }
            return proxifiedBaseUrl;
        }
        catch (URISyntaxException urise) {
            throw new RuntimeException("Invalid Proxy Base URL property is set in your GeoServer installation.", urise);
        }
    }
}

