/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;

public class KvpRequestReader {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.ows");
    private Class requestBean;

    public KvpRequestReader(Class requestBean) {
        if (requestBean == null) {
            throw new NullPointerException();
        }
        this.requestBean = requestBean;
    }

    public final Class getRequestBean() {
        return this.requestBean;
    }

    public Object createRequest() throws Exception {
        return this.getRequestBean().newInstance();
    }

    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        Iterator e = kvp.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            String property = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            Method setter = OwsUtils.setter(request.getClass(), property, value.getClass());
            if (setter == null && (setter = OwsUtils.setter(request.getClass(), property, null)) != null) {
                Class<?> target = setter.getParameterTypes()[0];
                Object converted = Converters.convert(value, target);
                if (converted != null) {
                    value = converted;
                } else {
                    setter = null;
                }
            }
            if (setter == null) continue;
            setter.invoke(request, value);
        }
        return request;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof KvpRequestReader) {
            KvpRequestReader other = (KvpRequestReader)obj;
            return this.requestBean == other.requestBean;
        }
        return false;
    }

    public final int hashCode() {
        return this.requestBean.hashCode();
    }
}

