/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.UserContainer;

public final class Requests {
    static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver");
    public static final String PROXY_PARAM = "PROXY_BASE_URL";

    public static String getBaseUrl(HttpServletRequest httpServletRequest, GeoServer geoserver) {
        String url;
        String string = url = geoserver != null ? geoserver.getProxyBaseUrl() : null;
        if (url == null || url.trim().length() == 0) {
            if (httpServletRequest != null) {
                url = httpServletRequest.getSession().getServletContext().getInitParameter(PROXY_PARAM);
            }
            url = url == null || url.trim().length() == 0 ? httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getContextPath() + "/" : Requests.appendContextPath(url, httpServletRequest.getContextPath());
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    public static String getBaseJspUrl(HttpServletRequest httpServletRequest, GeoServer geoserver) {
        String url = geoserver.getProxyBaseUrl();
        if (geoserver != null && url != null) {
            url = Requests.appendContextPath(url, httpServletRequest.getRequestURI());
        }
        if (url == null || url.trim().length() == 0) {
            if (httpServletRequest != null) {
                url = httpServletRequest.getSession().getServletContext().getInitParameter(PROXY_PARAM);
            }
            url = url == null || url.trim().length() == 0 ? httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getRequestURI() + "/" : Requests.appendContextPath(url, httpServletRequest.getRequestURI());
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String getTileCacheBaseUrl(HttpServletRequest request, GeoServer geoServer) {
        String tileCacheBaseUrl = geoServer.getTileCache();
        if (tileCacheBaseUrl != null) {
            try {
                new URL(tileCacheBaseUrl);
                return tileCacheBaseUrl;
            }
            catch (MalformedURLException e1) {
                try {
                    String url = Requests.appendContextPath(request.getScheme() + "://" + request.getServerName(), tileCacheBaseUrl);
                    new URL(url);
                    return url;
                }
                catch (MalformedURLException e2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static String appendContextPath(String url, String contextPath) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        return url + "/" + contextPath;
    }

    public static String appendQueryString(String url, String queryString) {
        if (url.endsWith("?") || url.endsWith("&")) {
            return url + queryString;
        }
        if (url.indexOf(63) != -1) {
            return url + "&" + queryString;
        }
        return url + "?" + queryString;
    }

    public static String getSchemaBaseUrl(HttpServletRequest httpServletRequest, GeoServer geoserver) {
        return Requests.getBaseUrl(httpServletRequest, geoserver) + "schemas/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserContainer getUserContainer(HttpServletRequest request) {
        HttpSession session;
        HttpSession httpSession = session = request.getSession();
        synchronized (httpSession) {
            UserContainer user = (UserContainer)session.getAttribute("GEOSERVER.USER");
            if (user == null) {
                user = new UserContainer();
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                if (authentication == null) {
                    LOGGER.warning("Warning, Acegi security subsystem deactivated, no user checks will be made");
                    user.setUsername("admin");
                } else {
                    Object o = authentication.getPrincipal();
                    if (o instanceof UserDetails) {
                        UserDetails ud = (UserDetails)o;
                        user.setUsername(ud.getUsername());
                    } else if (o instanceof String) {
                        user.setUsername((String)o);
                    }
                }
                request.getSession().setAttribute("GEOSERVER.USER", (Object)user);
            }
            return user;
        }
    }

    public static boolean loggedIn(HttpServletRequest request) {
        return !Requests.getUserContainer(request).getUsername().equals("anonymous");
    }

    public static boolean isLoggedIn(HttpServletRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && !(authentication instanceof AnonymousAuthenticationToken);
    }

    public static void logOut(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.removeAttribute("GEOSERVER.USER");
    }

    public static InputStream getInputStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpURLConnection) {
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        conn.connect();
        if (conn instanceof HttpURLConnection) {
            String encoding = conn.getContentEncoding();
            if (encoding == null) {
                encoding = "";
            }
            if (encoding.equalsIgnoreCase("gzip")) {
                return new GZIPInputStream(conn.getInputStream());
            }
            if (encoding.equalsIgnoreCase("deflate")) {
                return new InflaterInputStream(conn.getInputStream(), new Inflater(true));
            }
            return conn.getInputStream();
        }
        return conn.getInputStream();
    }

    public static Map parseOptionParameter(String rawOptionString) throws IllegalArgumentException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (rawOptionString == null) {
            return map;
        }
        StringTokenizer semiColonSplitter = new StringTokenizer(rawOptionString, ";");
        while (semiColonSplitter.hasMoreElements()) {
            String curKVP = semiColonSplitter.nextToken();
            int cloc = curKVP.indexOf(":");
            if (cloc <= 0) {
                throw new IllegalArgumentException("Key-value-pair: '" + curKVP + "' isn't properly formed.  It must be of the form 'Key:Value1,Value2...'");
            }
            String key = curKVP.substring(0, cloc);
            String values = curKVP.substring(cloc + 1, curKVP.length());
            if (values.indexOf(",") != -1) {
                ArrayList<String> valueList = new ArrayList<String>();
                StringTokenizer commaSplitter = new StringTokenizer(values, ",");
                while (commaSplitter.hasMoreElements()) {
                    valueList.add(commaSplitter.nextToken());
                }
                map.put(key, valueList);
                continue;
            }
            map.put(key, values);
        }
        return map;
    }
}

