/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.ConfigurationException;

public class WriterHelper {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");
    protected Writer writer;
    protected int indent;
    protected StringBuffer indentBuffer = new StringBuffer();

    protected WriterHelper() {
    }

    public WriterHelper(Writer writer) {
        this.writer = writer;
    }

    public void writeln(String s) throws ConfigurationException {
        try {
            this.writer.write(this.indentBuffer.subSequence(0, this.indent) + s + "\n");
            this.writer.flush();
        }
        catch (IOException e) {
            throw new ConfigurationException("Writeln" + this.writer, e);
        }
    }

    private void increaseIndent() {
        this.indent += 2;
        this.indentBuffer.append("  ");
    }

    private void decreaseIndent() {
        if (this.indent > 0) {
            this.indent -= 2;
            this.indentBuffer.setLength(this.indentBuffer.length() - 2);
        }
    }

    public void openTag(String tagName) throws ConfigurationException {
        this.openTag(tagName, Collections.EMPTY_MAP);
    }

    public void openTag(String tagName, Map attributes) throws ConfigurationException {
        StringBuffer sb = new StringBuffer();
        sb.append("<" + tagName + " ");
        for (String s : attributes.keySet()) {
            if (attributes.get(s) == null) continue;
            sb.append(s + " = " + "\"" + this.escape(attributes.get(s).toString()) + "\" ");
        }
        sb.append(">");
        this.writeln(sb.toString());
        this.increaseIndent();
    }

    public void closeTag(String tagName) throws ConfigurationException {
        this.decreaseIndent();
        this.writeln("</" + tagName + ">");
    }

    public void valueTag(String tagName, String value) throws ConfigurationException {
        this.writeln("<" + tagName + " value = \"" + this.escape(value) + "\" />");
    }

    public void attrTag(String tagName, Map attributes) throws ConfigurationException {
        StringBuffer sb = new StringBuffer();
        sb.append("<" + tagName + " ");
        for (String s : attributes.keySet()) {
            if (attributes.get(s) == null) continue;
            sb.append(s + " = " + "\"" + this.escape(attributes.get(s).toString()) + "\" ");
        }
        sb.append("/>");
        this.writeln(sb.toString());
    }

    public void textTag(String tagName, String data) throws ConfigurationException {
        this.textTag(tagName, Collections.EMPTY_MAP, data);
    }

    public void textTag(String tagName, Map attributes, String data) throws ConfigurationException {
        StringBuffer sb = new StringBuffer();
        sb.append("<" + tagName + (attributes.size() > 0 ? " " : ""));
        for (String s : attributes.keySet()) {
            if (attributes.get(s) == null) continue;
            sb.append(s + " = " + "\"" + this.escape(attributes.get(s).toString()) + "\" ");
        }
        String escapedData = "";
        if (data != null) {
            escapedData = this.escape(data);
        }
        sb.append(">" + escapedData + "</" + tagName + ">");
        this.writeln(sb.toString());
    }

    public void comment(String comment) throws ConfigurationException {
        this.writeln("<!--");
        this.increaseIndent();
        String ib = this.indentBuffer.substring(0, this.indent);
        comment = comment.trim();
        comment = comment.replaceAll("\n", "\n" + ib);
        this.writeln(comment);
        this.decreaseIndent();
        this.writeln("-->");
    }

    private String escape(String text) {
        String s = new String(text);
        if ((s = s.replaceAll("\r\n", "\n")).matches("(.*)[\"&'<>]*(.*)(\\n)*")) {
            s = s.replaceAll("\"", "&quot;");
            s = s.replaceAll("&", "&amp;");
            s = s.replaceAll("'", "&apos;");
            s = s.replaceAll("<", "&lt;");
            s = s.replaceAll(">", "&gt;");
        }
        return s;
    }
}

