/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import com.sun.media.jai.util.SunTileCache;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.media.jai.JAI;
import javax.servlet.ServletContext;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.RollingFileAppender;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.jai.JAIInfo;
import org.springframework.beans.factory.DisposableBean;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.dto.ContactDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;

public class GeoServer
extends GlobalLayerSupertype
implements DisposableBean {
    public static final String WEB_CONTAINER_KEY = "GeoServer";
    public static boolean suppressLoggingConfiguration;
    org.geoserver.config.GeoServer gs;
    GeoServerInfo info;

    protected GeoServer() {
    }

    public GeoServer(org.geoserver.config.GeoServer gs) {
        this.gs = gs;
        this.init();
    }

    public void init() {
        this.info = this.gs.getGlobal();
    }

    public void addListener(Listener listener) {
    }

    public void removeListener(Listener listener) {
    }

    public void fireChange() {
    }

    public String getAddress() {
        return this.info.getContactInfo().getAddress();
    }

    public String getAddressCity() {
        return this.info.getContactInfo().getAddressCity();
    }

    public String getAddressCountry() {
        return this.info.getContactInfo().getAddressCountry();
    }

    public String getAddressPostalCode() {
        return this.info.getContactInfo().getAddressPostalCode();
    }

    public String getAddressState() {
        return this.info.getContactInfo().getAddressState();
    }

    public String getAddressType() {
        return this.info.getContactInfo().getAddressType();
    }

    public Charset getCharSet() {
        return Charset.forName(this.info.getCharset());
    }

    public String getContactEmail() {
        return this.info.getContactInfo().getContactEmail();
    }

    public String getContactFacsimile() {
        return this.info.getContactInfo().getContactFacsimile();
    }

    public String getContactOrganization() {
        return this.info.getContactInfo().getContactOrganization();
    }

    public String getContactPerson() {
        return this.info.getContactInfo().getContactPerson();
    }

    public String getContactPosition() {
        return this.info.getContactInfo().getContactPosition();
    }

    public String getContactVoice() {
        return this.info.getContactInfo().getContactVoice();
    }

    public String getOnlineResource() {
        return this.info.getOnlineResource();
    }

    public String getLog4jConfigFile() {
        return this.info.getLoggingLevel();
    }

    public int getMaxFeatures() {
        return this.info.getMaxFeatures();
    }

    public String getMimeType() {
        return "text/xml; charset=" + this.getCharSet().name();
    }

    public int getNumDecimals() {
        return this.info.getNumDecimals();
    }

    public String getSchemaBaseUrl() {
        return this.info.getSchemaBaseUrl();
    }

    public String getProxyBaseUrl() {
        return this.info.getProxyBaseUrl();
    }

    public int getUpdateSequence() {
        return this.info.getUpdateSequence();
    }

    public void setUpdateSequence(int updateSequence) {
        this.info.setUpdateSequence(updateSequence);
    }

    public boolean isVerbose() {
        return this.info.isVerbose();
    }

    public void load(GeoServerDTO dto) throws ConfigurationException {
        if (dto != null) {
            ContactInfo contact = this.gs.getFactory().createContact();
            contact.setAddress(dto.getContact().getAddress());
            contact.setAddressCity(dto.getContact().getAddressCity());
            contact.setAddressCountry(dto.getContact().getAddressCountry());
            contact.setAddressPostalCode(dto.getContact().getAddressPostalCode());
            contact.setAddressState(dto.getContact().getAddressState());
            contact.setAddressType(dto.getContact().getAddressType());
            contact.setContactEmail(dto.getContact().getContactEmail());
            contact.setContactFacsimile(dto.getContact().getContactFacsimile());
            contact.setContactOrganization(dto.getContact().getContactOrganization());
            contact.setContactPerson(dto.getContact().getContactPerson());
            contact.setContactPosition(dto.getContact().getContactPosition());
            contact.setContactVoice(dto.getContact().getContactVoice());
            contact.setOnlineResource(dto.getContact().getOnlineResource());
            this.info.setContactInfo(contact);
            this.info.setLoggingLevel(dto.getLog4jConfigFile());
            this.info.setStdOutLogging(!dto.getSuppressStdOutLogging());
            this.info.setLoggingLocation(dto.getLogLocation());
            JAIInfo jai = new JAIInfo();
            jai.setMemoryCapacity(dto.getJaiMemoryCapacity());
            jai.setMemoryThreshold(dto.getJaiMemoryThreshold());
            jai.setTileThreads(dto.getJaiTileThreads());
            jai.setTilePriority(dto.getJaiTilePriority());
            jai.setRecycling(dto.getJaiRecycling());
            jai.setImageIOCache(dto.getImageIOCache());
            jai.setPNGAcceleration(dto.getJaiPNGNative());
            jai.setJPEGAcceleration(dto.getJaiJPEGNative());
            this.info.getMetadata().put(JAIInfo.KEY, jai);
            this.info.setMaxFeatures(dto.getMaxFeatures());
            this.info.setNumDecimals(dto.getNumDecimals());
            this.info.setSchemaBaseUrl(dto.getSchemaBaseUrl());
            this.info.setProxyBaseUrl(dto.getProxyBaseUrl());
            this.info.setVerbose(dto.isVerbose());
            this.info.setVerboseExceptions(dto.isVerboseExceptions());
            this.info.setUpdateSequence(dto.getUpdateSequence());
            if (dto.getCharSet() != null) {
                this.info.setCharset(dto.getCharSet().toString());
            } else {
                this.info.setCharset("UTF-8");
            }
        } else {
            throw new ConfigurationException("load(GeoServerDTO) expected a non-null value");
        }
        this.gs.save(this.info);
    }

    public final void load(GeoServerDTO dto, ServletContext context) throws ConfigurationException {
        this.load(dto);
    }

    public static File getLogLocation(String logLocation) throws IOException {
        File f = new File(logLocation);
        if (f.exists()) {
            if (f.isDirectory()) {
                if (!logLocation.endsWith(File.separator)) {
                    logLocation = logLocation + File.separator;
                }
                logLocation = logLocation + "geoserver.log";
            }
        } else {
            if (!f.isAbsolute()) {
                File data = GeoserverDataDirectory.getGeoserverDataDirectory();
                f = new File(data, f.getPath());
            }
            if (f.getParentFile() != null && !f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            f.createNewFile();
        }
        return f;
    }

    public static void configureGeoServerLogging(InputStream loggingConfigStream, boolean suppressStdOutLogging, boolean suppressFileLogging, String logFileName) throws FileNotFoundException, IOException, ConfigurationException {
        Properties lprops = new Properties();
        lprops.load(loggingConfigStream);
        LogManager.resetConfiguration();
        PropertyConfigurator.configure((Properties)lprops);
        if (!suppressFileLogging) {
            Appender gslf = Logger.getRootLogger().getAppender("geoserverlogfile");
            if (gslf instanceof RollingFileAppender) {
                if (logFileName == null) {
                    logFileName = new File(GeoserverDataDirectory.findCreateConfigDir("logs"), "geoserver.log").getAbsolutePath();
                } else if (!new File(logFileName).isAbsolute()) {
                    logFileName = new File(GeoserverDataDirectory.getGeoserverDataDirectory(), logFileName).getAbsolutePath();
                    LOGGER.fine("Non-absolute pathname detected for logfile.  Setting logfile relative to data dir.");
                }
                lprops.setProperty("log4j.appender.geoserverlogfile.File", logFileName);
                PropertyConfigurator.configure((Properties)lprops);
                LOGGER.fine("Logging output to file '" + logFileName + "'");
            } else if (gslf != null) {
                LOGGER.warning("'log4j.appender.geoserverlogfile' appender is defined, but isn't a RollingFileAppender.  GeoServer won't control the file-based logging.");
            } else {
                LOGGER.warning("'log4j.appender.geoserverlogfile' appender isn't defined.  GeoServer won't control the file-based logging.");
            }
        }
        if (suppressStdOutLogging) {
            LOGGER.warning("Suppressing StdOut logging.  If you want to see GeoServer logs, be sure to look in '" + logFileName + "'");
            Enumeration allAppenders = Logger.getRootLogger().getAllAppenders();
            while (allAppenders.hasMoreElements()) {
                Appender curApp = (Appender)allAppenders.nextElement();
                if (!(curApp instanceof ConsoleAppender)) continue;
                Logger.getRootLogger().removeAppender(curApp);
            }
        }
        LOGGER.fine("FINISHED CONFIGURING GEOSERVER LOGGING -------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyResourceToFile(String resource, File target) throws ConfigurationException {
        InputStream is = null;
        OutputStream os = null;
        byte[] buffer = new byte[4096];
        try {
            int read;
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            os = new FileOutputStream(target);
            while ((read = is.read(buffer)) > 0) {
                os.write(buffer, 0, read);
            }
        }
        catch (FileNotFoundException targetException) {
            throw new ConfigurationException("Can't write to file " + target.getAbsolutePath() + ". Check write permissions on target folder for user " + System.getProperty("user.name"));
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error trying to copy logging configuration file", e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public GeoServerDTO toDTO() {
        GeoServerDTO dto = new GeoServerDTO();
        dto.setCharSet(this.getCharSet());
        dto.setMaxFeatures(this.getMaxFeatures());
        dto.setNumDecimals(this.getNumDecimals());
        dto.setSchemaBaseUrl(this.getSchemaBaseUrl());
        dto.setProxyBaseUrl(this.getProxyBaseUrl());
        dto.setVerbose(this.isVerbose());
        dto.setVerboseExceptions(this.isVerboseExceptions());
        dto.setLogLocation(this.getLogLocation());
        dto.setSuppressStdOutLogging(this.getSuppressStdOutLogging());
        dto.setLog4jConfigFile(this.getLog4jConfigFile());
        dto.setJaiMemoryCapacity(this.getMemoryCapacity());
        dto.setJaiMemoryThreshold(this.getMemoryThreshold());
        dto.setJaiTileThreads(this.getTileThreads());
        dto.setJaiTilePriority(this.getTilePriority());
        dto.setTileCache(this.getTileCache());
        dto.setJaiRecycling(this.getRecycling());
        dto.setImageIOCache(this.getImageIOCache());
        dto.setJaiJPEGNative(this.getJPEGNativeAcceleration());
        dto.setJaiPNGNative(this.getPNGNativeAcceleration());
        dto.setUpdateSequence(this.getUpdateSequence());
        ContactDTO cdto = new ContactDTO();
        dto.setContact(cdto);
        cdto.setAddress(this.getAddress());
        cdto.setAddressCity(this.getAddressCity());
        cdto.setAddressCountry(this.getAddressCountry());
        cdto.setAddressPostalCode(this.getAddressPostalCode());
        cdto.setAddressState(this.getAddressState());
        cdto.setAddressType(this.getAddressType());
        cdto.setContactEmail(this.getContactEmail());
        cdto.setContactFacsimile(this.getContactFacsimile());
        cdto.setContactOrganization(this.getContactOrganization());
        cdto.setContactPerson(this.getContactPerson());
        cdto.setContactPosition(this.getContactPosition());
        cdto.setContactVoice(this.getContactVoice());
        cdto.setOnlineResource(this.getOnlineResource());
        return dto;
    }

    public String getTitle() {
        return this.info.getTitle();
    }

    public void setTitle(String title) {
        this.info.setTitle(title);
    }

    public String getContactParty() {
        if (this.getContactPerson() != null && this.getContactPerson().length() != 0) {
            return this.getContactPerson();
        }
        if (this.getContactPosition() != null && this.getContactPosition().length() != 0) {
            return this.getContactPosition();
        }
        if (this.getContactOrganization() != null && this.getContactOrganization().length() != 0) {
            return this.getContactOrganization();
        }
        return null;
    }

    public String getAdminUserName() {
        return this.info.getAdminUsername();
    }

    public String getAdminPassword() {
        return this.info.getAdminPassword();
    }

    public String toString() {
        StringBuffer geoserver = new StringBuffer("[GeoServer: \n");
        geoserver.append("   maxFeatures - " + this.getMaxFeatures());
        geoserver.append("\n   verbose - " + this.isVerbose());
        geoserver.append("\n   numDecimals - " + this.getNumDecimals());
        geoserver.append("\n   charSet - " + this.getCharSet());
        geoserver.append("\n   log4jConfigFile - " + this.getLog4jConfigFile());
        geoserver.append("\n   adminUserName - " + this.getAdminUserName());
        geoserver.append("\n   adminPassword - " + this.getAdminPassword());
        return geoserver.toString();
    }

    public boolean isVerboseExceptions() {
        return this.info.isVerboseExceptions();
    }

    public void setVerboseExceptions(boolean showStackTraces) {
        this.info.setVerboseExceptions(showStackTraces);
    }

    public String getLogLocation() {
        return this.info.getLoggingLocation();
    }

    public void setLogLocation(String logLocation) {
        this.info.setLoggingLocation(logLocation);
    }

    public boolean getSuppressStdOutLogging() {
        return !this.info.isStdOutLogging();
    }

    public void setSuppressStdOutLogging(boolean loggingToFile) {
        this.info.setStdOutLogging(!loggingToFile);
    }

    JAIInfo jai() {
        return (JAIInfo)this.info.getMetadata().get(JAIInfo.KEY);
    }

    public JAI getJAIDefault() {
        return this.jai().getJAI();
    }

    public SunTileCache getJaiCache() {
        return this.jai().getTileCache();
    }

    public double getMemoryCapacity() {
        return this.jai().getMemoryCapacity();
    }

    public Boolean getRecycling() {
        return this.jai().getRecycling();
    }

    public Boolean getJPEGNativeAcceleration() {
        return this.jai().getJPEGAcceleration();
    }

    public Boolean getPNGNativeAcceleration() {
        return this.jai().getPNGAcceleration();
    }

    public double getMemoryThreshold() {
        return this.jai().getMemoryThreshold();
    }

    public Boolean getImageIOCache() {
        return this.jai().getImageIOCache();
    }

    public int getTilePriority() {
        return this.jai().getTilePriority();
    }

    public int getTileThreads() {
        return this.jai().getTileThreads();
    }

    public String getTileCache() {
        return null;
    }

    public void destroy() throws Exception {
    }

    public static void suppressLoggingConfiguration() {
        suppressLoggingConfiguration = true;
    }

    public static interface Listener {
        public void changed();
    }
}

