/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureSource;
import org.geotools.data.LockingManager;
import org.geotools.data.Transaction;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.springframework.beans.factory.DisposableBean;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.CoverageStoreInfo;
import org.vfny.geoserver.global.DataStoreInfo;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.GlobalLayerSupertype;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.global.dto.CoverageInfoDTO;
import org.vfny.geoserver.global.dto.CoverageStoreInfoDTO;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.DataStoreInfoDTO;
import org.vfny.geoserver.global.dto.DataTransferObjectFactory;
import org.vfny.geoserver.global.dto.FeatureTypeInfoDTO;
import org.vfny.geoserver.global.dto.NameSpaceInfoDTO;
import org.vfny.geoserver.global.dto.StyleDTO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Data
extends GlobalLayerSupertype
implements DisposableBean {
    public static final String WEB_CONTAINER_KEY = "DATA";
    public static final Integer TYPE_VECTOR = LayerInfo.Type.VECTOR.getCode();
    public static final Integer TYPE_RASTER = LayerInfo.Type.RASTER.getCode();
    private static StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
    private Map errors;
    org.geoserver.config.GeoServer gs;
    Catalog catalog;

    public Data(org.geoserver.config.GeoServer gs, Catalog catalog) {
        this.gs = gs;
        this.catalog = catalog;
    }

    public Data(org.geoserver.config.GeoServer gs) {
        this.gs = gs;
        this.catalog = gs.getCatalog();
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public GeoServer getGeoServer() {
        return new GeoServer(this.gs);
    }

    public void setDataDirectory(File dataDirectory) {
        throw new UnsupportedOperationException();
    }

    public File getDataDirectory() {
        return GeoserverDataDirectory.getGeoserverDataDirectory();
    }

    public synchronized void load(DataDTO config) {
        if (config == null) {
            throw new NullPointerException("Non null DataDTO required for load");
        }
        this.catalog.dispose();
        this.loadNamespaces(config);
        this.loadFormats(config);
        this.loadDataStores(config);
        this.loadStyles(config);
        this.loadFeatureTypes(config);
        this.loadCoverages(config);
    }

    public synchronized Set getDataStores() {
        HashSet<DataStoreInfo> dataStores = new HashSet<DataStoreInfo>();
        for (org.geoserver.catalog.DataStoreInfo ds : this.catalog.getDataStores()) {
            dataStores.add(new DataStoreInfo(ds, this.catalog));
        }
        return dataStores;
    }

    public synchronized Set getFormats() {
        HashSet<CoverageStoreInfo> coverageStores = new HashSet<CoverageStoreInfo>();
        for (org.geoserver.catalog.CoverageStoreInfo cs : this.catalog.getCoverageStores()) {
            coverageStores.add(new CoverageStoreInfo(cs, this.catalog));
        }
        return coverageStores;
    }

    private final Map loadFormats(DataDTO dto) {
        if (dto == null || dto.getFormats() == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap map = new HashMap();
        for (CoverageStoreInfoDTO formatDTO : dto.getFormats().values()) {
            org.geoserver.catalog.CoverageStoreInfo cs = this.catalog.getFactory().createCoverageStore();
            new CoverageStoreInfo(cs, this.catalog).load(formatDTO);
            this.catalog.add(cs);
        }
        return null;
    }

    private final Map loadDataStores(DataDTO dto) {
        if (dto == null || dto.getDataStores() == null) {
            return Collections.EMPTY_MAP;
        }
        for (DataStoreInfoDTO dataStoreDTO : dto.getDataStores().values()) {
            org.geoserver.catalog.DataStoreInfo ds = this.catalog.getFactory().createDataStore();
            new DataStoreInfo(ds, this.catalog).load(dataStoreDTO);
            try {
                ds.getDataStore(null);
                ds.setError(null);
            }
            catch (Exception e) {
                LOGGER.warning("Error connecting to data store '" + dataStoreDTO.getId() + "'");
                LOGGER.log(Level.WARNING, "", e);
                ds.setEnabled(false);
                ds.setError(e);
            }
            this.catalog.add(ds);
        }
        return null;
    }

    private final Map loadNamespaces(DataDTO dto) {
        if (dto == null || dto.getNameSpaces() == null) {
            return Collections.EMPTY_MAP;
        }
        for (NameSpaceInfoDTO namespaceDto : dto.getNameSpaces().values()) {
            NamespaceInfo ns = this.catalog.getFactory().createNamespace();
            new NameSpaceInfo(ns, this.catalog).load(namespaceDto);
            this.catalog.add(ns);
            WorkspaceInfo ws = this.catalog.getFactory().createWorkspace();
            ws.setName(ns.getPrefix());
            this.catalog.add(ws);
            if (!namespaceDto.isDefault()) continue;
            this.catalog.setDefaultNamespace(ns);
            this.catalog.setDefaultWorkspace(ws);
        }
        return null;
    }

    private final void loadCoverages(DataDTO dto) {
        for (CoverageInfoDTO cDTO : dto.getCoverages().values()) {
            LayerInfo layer;
            org.geoserver.catalog.CoverageInfo ci;
            org.geoserver.catalog.CoverageStoreInfo cs;
            block7: {
                cs = this.catalog.getCoverageStoreByName(cDTO.getFormatId());
                if (cs != null) {
                    if (!cs.isEnabled()) {
                        LOGGER.warning("Ignoring coverage '" + cDTO.getName() + "', coverage store '" + cDTO.getFormatId() + "' is disabled.");
                    }
                } else {
                    LOGGER.warning("Ignoring coverage '" + cDTO.getName() + "', data store '" + cDTO.getFormatId() + "' not found.");
                }
                ci = this.catalog.getFactory().createCoverage();
                CoverageStoreInfoDTO format = (CoverageStoreInfoDTO)dto.getFormats().get(cDTO.getFormatId());
                ci.setNamespace(this.catalog.getNamespaceByPrefix(format.getNameSpaceId()));
                layer = this.catalog.getFactory().createLayer();
                layer.setResource(ci);
                try {
                    new CoverageInfo(layer, this.catalog).load(cDTO);
                }
                catch (Exception e) {
                    if (cs == null || !cs.isEnabled()) break block7;
                    LOGGER.warning("Error loading coverage'" + cDTO.getName() + "'");
                    LOGGER.log(Level.INFO, "", e);
                    ci.setEnabled(false);
                }
            }
            if (ci.isEnabled() && (cs == null || !cs.isEnabled())) {
                ci.setEnabled(false);
            }
            this.catalog.add(ci);
            this.catalog.add(layer);
        }
    }

    private final void loadFeatureTypes(DataDTO dto) {
        for (FeatureTypeInfoDTO ftDTO : dto.getFeaturesTypes().values()) {
            LayerInfo layer;
            org.geoserver.catalog.FeatureTypeInfo fti;
            org.geoserver.catalog.DataStoreInfo ds;
            block7: {
                ds = this.catalog.getDataStoreByName(ftDTO.getDataStoreId());
                if (ds != null) {
                    if (!ds.isEnabled()) {
                        LOGGER.warning("Ignoring feature type '" + ftDTO.getName() + "', data store '" + ftDTO.getDataStoreId() + "' is disabled.");
                    }
                } else {
                    LOGGER.warning("Ignoring feature type '" + ftDTO.getName() + "', data store '" + ftDTO.getDataStoreId() + "' not found.");
                }
                fti = this.catalog.getFactory().createFeatureType();
                layer = this.catalog.getFactory().createLayer();
                layer.setResource(fti);
                try {
                    new FeatureTypeInfo(layer, this.catalog).load(ftDTO);
                }
                catch (Exception e) {
                    if (ds == null || !ds.isEnabled()) break block7;
                    LOGGER.warning("Error loading feature type '" + ftDTO.getName() + "'");
                    LOGGER.log(Level.INFO, "", e);
                    fti.setEnabled(false);
                }
            }
            if (fti.isEnabled() && (ds == null || !ds.isEnabled())) {
                fti.setEnabled(false);
            }
            this.catalog.add(fti);
            this.catalog.add(layer);
        }
    }

    private List createAttrDTOsFromSchema(SimpleFeatureType featureType) {
        List attrList = DataTransferObjectFactory.generateAttributes(featureType);
        return attrList;
    }

    private final Map loadStyles(DataDTO dto) {
        if (dto == null || dto.getStyles() == null) {
            return Collections.EMPTY_MAP;
        }
        for (StyleDTO styleDTO : dto.getStyles().values()) {
            StyleInfo s = this.catalog.getFactory().createStyle();
            s.setName(styleDTO.getId());
            s.setFilename(styleDTO.getFilename().getName());
            this.catalog.add(s);
            this.catalog.getResourcePool().clear(s);
        }
        return null;
    }

    static final void outputStatus(String title, Map status) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info(title);
        }
        for (Map.Entry entry : status.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == Boolean.TRUE) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine(new StringBuffer(key).append(": ready").toString());
                continue;
            }
            if (value instanceof Throwable) {
                Throwable t = (Throwable)value;
                if (!LOGGER.isLoggable(Level.SEVERE)) continue;
                LOGGER.log(Level.SEVERE, new StringBuffer(key).append(" not ready").toString(), t);
                continue;
            }
            if (!LOGGER.isLoggable(Level.WARNING)) continue;
            LOGGER.warning(new StringBuffer(key).append(": '").append(value).append("'").toString());
        }
    }

    public synchronized Map statusDataStores() {
        HashMap<org.geoserver.catalog.FeatureTypeInfo, Serializable> m = new HashMap<org.geoserver.catalog.FeatureTypeInfo, Serializable>();
        for (org.geoserver.catalog.FeatureTypeInfo ft : this.catalog.getFeatureTypes()) {
            org.geoserver.catalog.DataStoreInfo ds = ft.getStore();
            if (ds.getError() != null) {
                m.put(ft, ds.getError());
                continue;
            }
            m.put(ft, Boolean.valueOf(ft.isEnabled()));
        }
        return m;
    }

    public synchronized Map statusNamespaces() {
        HashMap m = new HashMap();
        return m;
    }

    @Override
    public synchronized DataDTO toDTO() {
        String key;
        DataDTO dto = new DataDTO();
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        NameSpaceInfo[] nameSpaces = this.getNameSpaces();
        for (int i = 0; i < nameSpaces.length; ++i) {
            tmp.put(nameSpaces[i].getPrefix(), nameSpaces[i].toDTO());
        }
        dto.setNameSpaces(tmp);
        if (this.getDefaultNameSpace() != null) {
            dto.setDefaultNameSpacePrefix(this.getDefaultNameSpace().getPrefix());
        }
        tmp = new HashMap();
        for (StyleInfo s : this.catalog.getStyles()) {
            StyleDTO sdto = new StyleDTO();
            sdto.setId(s.getName());
            sdto.setFilename(GeoserverDataDirectory.findStyleFile(s.getFilename()));
            sdto.setDefault(false);
            tmp.put(s.getName(), sdto);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("setting styles to: ").append(tmp).toString());
        }
        dto.setStyles(tmp);
        tmp = new HashMap();
        for (CoverageStoreInfo format : this.getFormats()) {
            tmp.put(format.getId(), format.toDTO());
        }
        dto.setFormats(tmp);
        tmp = new HashMap();
        for (DataStoreInfo dataStore : this.getDataStores()) {
            tmp.put(dataStore.getId(), dataStore.toDTO());
        }
        dto.setDataStores(tmp);
        tmp = new HashMap();
        for (Map.Entry entry : this.getFeatureTypeInfos().entrySet()) {
            key = (String)entry.getKey();
            FeatureTypeInfo fti = (FeatureTypeInfo)entry.getValue();
            tmp.put(key, fti.toDTO());
        }
        dto.setFeaturesTypes(tmp);
        tmp = new HashMap();
        for (Map.Entry entry : this.getCoverageInfos().entrySet()) {
            key = (String)entry.getKey();
            CoverageInfo ci = (CoverageInfo)entry.getValue();
            tmp.put(key, ci.toDTO());
        }
        dto.setCoverages(tmp);
        return dto;
    }

    public synchronized DataStoreInfo getDataStoreInfo(String id) {
        org.geoserver.catalog.DataStoreInfo ds = this.catalog.getDataStoreByName(id);
        return ds != null && ds.isEnabled() ? new DataStoreInfo(ds, this.catalog) : null;
    }

    public synchronized CoverageStoreInfo getFormatInfo(String id) {
        org.geoserver.catalog.CoverageStoreInfo cs = this.catalog.getCoverageStoreByName(id);
        return cs != null && cs.isEnabled() ? new CoverageStoreInfo(cs, this.catalog) : null;
    }

    public synchronized NameSpaceInfo[] getNameSpaces() {
        NameSpaceInfo[] ns = new NameSpaceInfo[this.catalog.getNamespaces().size()];
        int i = 0;
        for (NamespaceInfo namespace : this.catalog.getNamespaces()) {
            ns[i++] = new NameSpaceInfo(namespace, this.catalog);
        }
        return ns;
    }

    public synchronized NameSpaceInfo getNameSpace(String prefix) {
        NamespaceInfo ns = this.catalog.getNamespaceByPrefix(prefix);
        return ns != null ? new NameSpaceInfo(ns, this.catalog) : null;
    }

    public synchronized NameSpaceInfo getNameSpaceFromURI(String uri) {
        NamespaceInfo ns = this.catalog.getNamespaceByURI(uri);
        return ns != null ? new NameSpaceInfo(ns, this.catalog) : null;
    }

    public synchronized NameSpaceInfo getDefaultNameSpace() {
        return this.catalog.getDefaultNamespace() != null ? new NameSpaceInfo(this.catalog.getDefaultNamespace(), this.catalog) : null;
    }

    public synchronized Map getStyles() {
        HashMap<String, Style> styles = new HashMap<String, Style>();
        for (StyleInfo s : this.catalog.getStyles()) {
            try {
                styles.put(s.getName(), s.getStyle());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return styles;
    }

    public synchronized Style getStyle(String id) {
        StyleInfo s = this.catalog.getStyleByName(id);
        try {
            return s != null ? s.getStyle() : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized FeatureTypeInfo getFeatureTypeInfo(String name) throws NoSuchElementException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("getting type ").append(name).toString());
        }
        org.geoserver.catalog.FeatureTypeInfo ft = null;
        int i = name.indexOf(58);
        if (i > -1) {
            String prefix = name.substring(0, i);
            String local = name.substring(i + 1);
            ft = this.catalog.getFeatureTypeByName(prefix, local);
        } else {
            ft = this.catalog.getFeatureTypeByName(name);
        }
        if (ft != null) {
            List<LayerInfo> layers = this.catalog.getLayers(ft);
            return new FeatureTypeInfo(layers.get(0), this.catalog);
        }
        throw new NoSuchElementException("Could not locate FeatureTypeConfig '" + name + "'");
    }

    public FeatureTypeInfo getFeatureTypeInfo(QName name) {
        return this.getFeatureTypeInfo(name.getLocalPart(), name.getNamespaceURI());
    }

    public synchronized FeatureTypeInfo getFeatureTypeInfo(Name name) {
        return this.getFeatureTypeInfo(name.getLocalPart(), name.getNamespaceURI());
    }

    public synchronized FeatureTypeInfo getFeatureTypeInfo(String typename, String uri) {
        org.geoserver.catalog.FeatureTypeInfo ft = this.catalog.getFeatureTypeByName(uri, typename);
        if (ft == null) {
            ft = this.catalog.getFeatureTypeByName(typename);
        }
        if (ft != null) {
            return new FeatureTypeInfo(this.layer(ft), this.catalog);
        }
        return null;
    }

    public synchronized CoverageInfo getCoverageInfo(String name) throws NoSuchElementException {
        LOGGER.fine("getting coverage " + name);
        org.geoserver.catalog.CoverageInfo c = null;
        int i = name.indexOf(58);
        if (i > -1) {
            String prefix = name.substring(0, i);
            String local = name.substring(i + 1);
            c = this.catalog.getCoverageByName(prefix, local);
        } else {
            c = this.catalog.getCoverageByName(name);
        }
        if (c != null) {
            return new CoverageInfo(this.layer(c), this.catalog);
        }
        throw new NoSuchElementException("Could not locate CoverageConfig '" + name + "'");
    }

    public synchronized CoverageInfo getCoverageInfo(String name, String uri) {
        org.geoserver.catalog.CoverageInfo c = this.catalog.getCoverageByName(uri, name);
        if (c != null) {
            return new CoverageInfo(this.layer(c), this.catalog);
        }
        return null;
    }

    public MapLayerInfo getMapLayerInfo(String layerName) {
        Integer layerType = this.getLayerType(layerName);
        if (layerType == TYPE_VECTOR) {
            return new MapLayerInfo(this.getFeatureTypeInfo(layerName));
        }
        if (layerType == TYPE_RASTER) {
            return new MapLayerInfo(this.getCoverageInfo(layerName));
        }
        return null;
    }

    public synchronized Map getFeatureTypeInfos() {
        HashMap<String, FeatureTypeInfo> map = new HashMap<String, FeatureTypeInfo>();
        for (org.geoserver.catalog.FeatureTypeInfo ft : this.catalog.getFeatureTypes()) {
            map.put(ft.getPrefixedName(), new FeatureTypeInfo(this.layer(ft), this.catalog));
        }
        return map;
    }

    LayerInfo layer(ResourceInfo r) {
        List<LayerInfo> layers = this.catalog.getLayers(r);
        if (layers.size() > 0) {
            return layers.get(0);
        }
        return null;
    }

    public synchronized Map getCoverageInfos() {
        HashMap<String, CoverageInfo> map = new HashMap<String, CoverageInfo>();
        for (org.geoserver.catalog.CoverageInfo c : this.catalog.getCoverages()) {
            map.put(c.getPrefixedName(), new CoverageInfo(this.layer(c), this.catalog));
        }
        return map;
    }

    public Style loadStyle(String fileName, String base) throws IOException {
        return this.loadStyle(new File(base + fileName));
    }

    public Style loadStyle(File fileName) throws IOException {
        SLDParser stylereader = new SLDParser(styleFactory, fileName);
        return stylereader.readXML()[0];
    }

    public synchronized int getConnectionCount() {
        int count = 0;
        for (DataStoreInfo meta : this.getDataStores()) {
            if (!meta.isEnabled()) continue;
            try {
                DataStore dataStore = meta.getDataStore();
            }
            catch (Throwable notAvailable) {
                continue;
            }
            ++count;
        }
        return count;
    }

    public synchronized int getLockCount() {
        int count = 0;
        for (DataStoreInfo meta : this.getDataStores()) {
            DataStore dataStore;
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            catch (Throwable huh) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager != null) continue;
        }
        return count;
    }

    public synchronized int lockReleaseAll() {
        int count = 0;
        for (DataStoreInfo meta : this.getDataStores()) {
            DataStore dataStore;
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            catch (Throwable huh) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager != null) continue;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void lockRelease(String lockID) {
        boolean refresh = false;
        for (DataStoreInfo meta : this.getDataStores()) {
            DataStore dataStore;
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager == null) continue;
            DefaultTransaction t = new DefaultTransaction("Refresh " + meta.getNameSpace());
            try {
                t.addAuthorization(lockID);
                if (!lockingManager.release(lockID, (Transaction)t)) continue;
                refresh = true;
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
            finally {
                try {
                    t.close();
                }
                catch (IOException closeException) {
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                }
            }
        }
        if (!refresh) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void lockRefresh(String lockID) {
        boolean refresh = false;
        for (DataStoreInfo meta : this.getDataStores()) {
            DataStore dataStore;
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager == null) continue;
            DefaultTransaction t = new DefaultTransaction("Refresh " + meta.getNameSpace());
            try {
                t.addAuthorization(lockID);
                if (!lockingManager.refresh(lockID, (Transaction)t)) continue;
                refresh = true;
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
            finally {
                try {
                    t.close();
                }
                catch (IOException closeException) {
                    if (!LOGGER.isLoggable(Level.FINEST)) continue;
                    LOGGER.log(Level.FINEST, closeException.getMessage(), closeException);
                }
            }
        }
        if (!refresh) {
            // empty if block
        }
    }

    public synchronized boolean lockRefresh(String lockID, Transaction t) throws IOException {
        boolean refresh = false;
        for (DataStoreInfo meta : this.getDataStores()) {
            DataStore dataStore;
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager == null || !lockingManager.refresh(lockID, t)) continue;
            refresh = true;
        }
        return refresh;
    }

    public synchronized boolean lockRelease(String lockID, Transaction t) throws IOException {
        boolean release = false;
        for (DataStoreInfo meta : this.getDataStores()) {
            DataStore dataStore;
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager == null || !lockingManager.release(lockID, t)) continue;
            release = true;
        }
        return release;
    }

    public synchronized boolean lockExists(String lockID) {
        for (DataStoreInfo meta : this.getDataStores()) {
            DataStore dataStore;
            if (!meta.isEnabled()) continue;
            try {
                dataStore = meta.getDataStore();
            }
            catch (IllegalStateException notAvailable) {
                continue;
            }
            LockingManager lockingManager = dataStore.getLockingManager();
            if (lockingManager == null || !lockingManager.exists(lockID)) continue;
            return true;
        }
        return false;
    }

    public synchronized Set getPrefixes() {
        HashSet<String> prefixes = new HashSet<String>();
        for (NamespaceInfo ns : this.catalog.getNamespaces()) {
            prefixes.add(ns.getPrefix());
        }
        return prefixes;
    }

    public synchronized String getDefaultPrefix() {
        return this.catalog.getDefaultNamespace().getPrefix();
    }

    public synchronized NameSpaceInfo getNamespaceMetaData(String prefix) {
        return this.getNameSpace(prefix);
    }

    public synchronized void registerDataStore(DataStore dataStore) throws IOException {
    }

    public synchronized FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(String prefix, String typeName) throws IOException {
        if (prefix == null || prefix == "") {
            prefix = this.getDefaultPrefix();
        }
        NameSpaceInfo namespace = this.getNamespaceMetaData(prefix);
        FeatureTypeInfo featureType = namespace.getFeatureTypeInfo(typeName);
        DataStoreInfo dataStore = featureType.getDataStoreMetaData();
        return dataStore.getDataStore().getFeatureSource(typeName);
    }

    public Integer getLayerType(String layerName) {
        LayerInfo layer;
        int i = layerName.indexOf(58);
        if (i > -1) {
            layerName = layerName.substring(i + 1);
        }
        if ((layer = this.catalog.getLayerByName(layerName)) == null) {
            return null;
        }
        return layer.getType().getCode();
    }

    public Set getLayerNames() {
        HashSet<String> layerNames = new HashSet<String>();
        for (LayerInfo l : this.catalog.getLayers()) {
            layerNames.add(l.getName());
        }
        return layerNames;
    }

    public void destroy() throws Exception {
        Data catalog = this;
        Set dataStores = catalog.getDataStores();
        LOGGER.info("Disposing DataStores at GeoServer shutdown...");
        for (DataStoreInfo dataStoreInfo : dataStores) {
            LOGGER.fine("Disposing " + dataStoreInfo.getId());
            try {
                dataStoreInfo.dispose();
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Caught exception while disposing datastore " + dataStoreInfo.getId(), e);
            }
        }
        for (CoverageStoreInfo info : catalog.getFormats()) {
            info.dispose();
        }
        LOGGER.info("Done disposing datastores.");
    }
}

