/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.decorators.DecoratingDataStore;
import org.geoserver.security.decorators.ReadOnlyFeatureLocking;
import org.geoserver.security.decorators.ReadOnlyFeatureSource;
import org.geoserver.security.decorators.ReadOnlyFeatureStore;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyDataStore
extends DecoratingDataStore {
    boolean challenge;

    public ReadOnlyDataStore(DataStore delegate, boolean challenge) {
        super(delegate);
        this.challenge = challenge;
    }

    @Override
    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(Name typeName) throws IOException {
        FeatureSource<SimpleFeatureType, SimpleFeature> fs = super.getFeatureSource(typeName);
        return this.wrapFeatureSource(fs);
    }

    @Override
    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(String typeName) throws IOException {
        FeatureSource<SimpleFeatureType, SimpleFeature> fs = super.getFeatureSource(typeName);
        return this.wrapFeatureSource(fs);
    }

    FeatureSource<SimpleFeatureType, SimpleFeature> wrapFeatureSource(FeatureSource<SimpleFeatureType, SimpleFeature> fs) {
        if (fs == null) {
            return null;
        }
        if (!this.challenge) {
            return new ReadOnlyFeatureSource<SimpleFeatureType, SimpleFeature>(fs, false);
        }
        if (fs instanceof FeatureLocking) {
            return new ReadOnlyFeatureLocking<SimpleFeatureType, SimpleFeature>((FeatureLocking)fs, this.challenge);
        }
        if (fs instanceof FeatureSource) {
            return new ReadOnlyFeatureStore<SimpleFeatureType, SimpleFeature>((FeatureStore)fs, this.challenge);
        }
        return new ReadOnlyFeatureSource<SimpleFeatureType, SimpleFeature>(fs, this.challenge);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    @Override
    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    @Override
    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    RuntimeException notifyUnsupportedOperation() {
        if (this.challenge) {
            return SecureCatalogImpl.unauthorizedAccess();
        }
        return new UnsupportedOperationException("This datastore is read only");
    }
}

