/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.decorators.DecoratingDataAccess;
import org.geoserver.security.decorators.ReadOnlyFeatureLocking;
import org.geoserver.security.decorators.ReadOnlyFeatureSource;
import org.geoserver.security.decorators.ReadOnlyFeatureStore;
import org.geotools.data.DataAccess;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyDataAccess<T extends FeatureType, F extends Feature>
extends DecoratingDataAccess<T, F> {
    static final String READ_ONLY = "This data access is read only";
    boolean challenge;

    public ReadOnlyDataAccess(DataAccess<T, F> delegate, boolean challenge) {
        super(delegate);
        this.challenge = challenge;
    }

    @Override
    public FeatureSource<T, F> getFeatureSource(Name typeName) throws IOException {
        FeatureSource fs = super.getFeatureSource(typeName);
        if (fs == null) {
            return null;
        }
        if (!this.challenge) {
            return new ReadOnlyFeatureSource(fs, false);
        }
        if (fs instanceof FeatureLocking) {
            return new ReadOnlyFeatureLocking((FeatureLocking)fs, this.challenge);
        }
        if (fs instanceof FeatureStore) {
            return new ReadOnlyFeatureStore((FeatureStore)fs, this.challenge);
        }
        return new ReadOnlyFeatureSource(fs, this.challenge);
    }

    @Override
    public void createSchema(T featureType) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    @Override
    public void updateSchema(Name typeName, T featureType) throws IOException {
        throw this.notifyUnsupportedOperation();
    }

    RuntimeException notifyUnsupportedOperation() {
        if (this.challenge) {
            return SecureCatalogImpl.unauthorizedAccess();
        }
        return new UnsupportedOperationException("This datastore is read only");
    }
}

