/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.io.File;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.util.LegacyImporterSupport;
import org.geoserver.config.util.LegacyServicesReader;
import org.geotools.util.logging.Logging;

public class LegacyLoggingImporter
extends LegacyImporterSupport {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.confg");
    GeoServer geoServer;

    public LegacyLoggingImporter(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public void imprt(File dir) throws Exception {
        LegacyServicesReader reader = this.reader(dir);
        GeoServerInfo info = this.geoServer.getGlobal();
        if (info == null) {
            info = this.geoServer.getFactory().createGlobal();
            this.geoServer.setGlobal(info);
        }
        Map<String, Object> global = reader.global();
        info.setLoggingLevel((String)global.get("log4jConfigFile"));
        info.setLoggingLocation((String)global.get("logLocation"));
        if (global.get("suppressStdOutLogging") != null) {
            info.setStdOutLogging(this.get(global, "suppressStdOutLogging", Boolean.class) == false);
        } else {
            info.setStdOutLogging(true);
        }
    }
}

