/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.Wrapper;
import org.geoserver.catalog.util.LegacyCatalogImporter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.ServiceLoader;
import org.geoserver.config.util.LegacyConfigurationImporter;
import org.geoserver.config.util.LegacyLoggingImporter;
import org.geoserver.logging.LoggingInitializer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.vfny.geoserver.global.GeoserverDataDirectory;

public final class GeoServerLoader
implements BeanPostProcessor,
DisposableBean,
ApplicationContextAware {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver");
    GeoServerResourceLoader resourceLoader;
    GeoServer geoserver;

    public GeoServerLoader(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        GeoserverDataDirectory.init((WebApplicationContext)applicationContext);
    }

    public final Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public final Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof GeoServer) {
            this.geoserver = (GeoServer)bean;
            this.initialize();
        }
        return bean;
    }

    protected void initialize() {
        LegacyLoggingImporter loggingImporter = new LegacyLoggingImporter(this.geoserver);
        try {
            loggingImporter.imprt(this.resourceLoader.getBaseDirectory());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            LoggingInitializer loggingIniter = new LoggingInitializer();
            loggingIniter.setResourceLoader(this.resourceLoader);
            loggingIniter.initialize(this.geoserver);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LegacyCatalogImporter catalogImporter = new LegacyCatalogImporter();
        catalogImporter.setResourceLoader(this.resourceLoader);
        Catalog catalog = this.geoserver.getCatalog();
        if (catalog instanceof Wrapper && ((Wrapper)((Object)catalog)).isWrapperFor(Catalog.class)) {
            catalog = ((Wrapper)((Object)catalog)).unwrap(Catalog.class);
        }
        catalogImporter.setCatalog(catalog);
        try {
            catalogImporter.imprt(this.resourceLoader.getBaseDirectory());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LegacyConfigurationImporter importer = new LegacyConfigurationImporter();
        importer.setConfiguration(this.geoserver);
        try {
            importer.imprt(this.resourceLoader.getBaseDirectory());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List initializers = GeoServerExtensions.extensions(GeoServerInitializer.class);
        for (GeoServerInitializer initer : initializers) {
            try {
                initer.initialize(this.geoserver);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void reload() throws Exception {
        this.destroy();
        this.initialize();
    }

    public void destroy() throws Exception {
        Collection<? extends ServiceInfo> services = this.geoserver.getServices();
        List loaders = GeoServerExtensions.extensions(ServiceLoader.class);
        block2: for (ServiceInfo serviceInfo : services) {
            for (ServiceLoader loader : loaders) {
                if (!loader.getServiceId().equals(serviceInfo.getId())) continue;
                try {
                    loader.save(serviceInfo, this.geoserver);
                    continue block2;
                }
                catch (Throwable t) {
                    LOGGER.warning("Error persisting service: " + serviceInfo.getId());
                    LOGGER.log(Level.INFO, "", t);
                }
            }
        }
        this.geoserver.dispose();
    }
}

