/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.geoserver.catalog.util.ReaderUtils;
import org.geoserver.ows.util.XmlCharsetDetector;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyCoverageInfoReader {
    Element coverage;
    File parentDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(File file) throws IOException {
        this.parentDirectory = file.getParentFile();
        Reader reader = XmlCharsetDetector.getCharsetAwareReader((InputStream)new FileInputStream(file));
        try {
            this.coverage = ReaderUtils.parse(reader);
        }
        finally {
            reader.close();
        }
    }

    public String format() {
        return this.coverage.getAttribute("format");
    }

    public String name() {
        return ReaderUtils.getChildText(this.coverage, "name");
    }

    public String description() {
        return ReaderUtils.getChildText(this.coverage, "description");
    }

    public String label() {
        return ReaderUtils.getChildText(this.coverage, "label");
    }

    public Map<String, String> metadataLink() {
        HashMap<String, String> ml = new HashMap<String, String>();
        ml.put("about", ReaderUtils.getChildAttribute(this.coverage, "metadataLink", "about"));
        ml.put("metadataType", ReaderUtils.getChildAttribute(this.coverage, "metadataLink", ",metadataType"));
        return ml;
    }

    public List<String> keywords() {
        String raw = ReaderUtils.getChildText(this.coverage, "keywords");
        StringTokenizer st = new StringTokenizer(raw, ", ");
        ArrayList<String> keywords = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            keywords.add(st.nextToken());
        }
        return keywords;
    }

    public String defaultStyle() throws Exception {
        Element styles = ReaderUtils.getChildElement(this.coverage, "styles");
        return ReaderUtils.getAttribute(styles, "default", true);
    }

    public Map<String, Object> envelope() throws Exception {
        Element envelopeElement = ReaderUtils.getChildElement(this.coverage, "envelope");
        HashMap<String, Object> e = new HashMap<String, Object>();
        String nativeCrsWkt = ReaderUtils.getAttribute(envelopeElement, "crs", false);
        nativeCrsWkt = nativeCrsWkt.replaceAll("'", "\"");
        e.put("crs", nativeCrsWkt);
        e.put("srsName", ReaderUtils.getAttribute(envelopeElement, "srsName", false));
        Element[] posElements = ReaderUtils.getChildElements(envelopeElement, "pos");
        String[] pos1 = posElements[0].getFirstChild().getTextContent().split(" ");
        String[] pos2 = posElements[1].getFirstChild().getTextContent().split(" ");
        e.put("x1", Double.parseDouble(pos1[0]));
        e.put("y1", Double.parseDouble(pos1[1]));
        e.put("x2", Double.parseDouble(pos2[0]));
        e.put("y2", Double.parseDouble(pos2[1]));
        return e;
    }

    public Map<String, Object> grid() throws Exception {
        Element gridElement = ReaderUtils.getChildElement(this.coverage, "grid");
        HashMap<String, Object> grid = new HashMap<String, Object>();
        grid.put("dimension", Integer.parseInt(ReaderUtils.getAttribute(gridElement, "dimension", true)));
        Element lowElement = ReaderUtils.getChildElement(gridElement, "low");
        String[] lows = lowElement.getFirstChild().getTextContent().trim().split(" ");
        int[] low = new int[lows.length];
        for (int i = 0; i < low.length; ++i) {
            low[i] = Integer.parseInt(lows[i]);
        }
        grid.put("low", low);
        Element highElement = ReaderUtils.getChildElement(gridElement, "high");
        String[] highs = highElement.getFirstChild().getTextContent().trim().split(" ");
        int[] high = new int[highs.length];
        for (int i = 0; i < high.length; ++i) {
            high[i] = Integer.parseInt(highs[i]);
        }
        grid.put("high", high);
        Element[] axisNameElements = ReaderUtils.getChildElements(gridElement, "axisName");
        String[] axisName = new String[axisNameElements.length];
        for (int i = 0; i < axisName.length; ++i) {
            axisName[i] = axisNameElements[i].getFirstChild().getTextContent();
        }
        grid.put("axisName", axisName);
        Element geoTransformElement = ReaderUtils.getChildElement(gridElement, "geoTransform");
        if (geoTransformElement != null) {
            HashMap<String, Double> geoTransform = new HashMap<String, Double>();
            String scaleX = ReaderUtils.getChildText(geoTransformElement, "scaleX");
            String scaleY = ReaderUtils.getChildText(geoTransformElement, "scaleY");
            String shearX = ReaderUtils.getChildText(geoTransformElement, "shearX");
            String shearY = ReaderUtils.getChildText(geoTransformElement, "shearY");
            String translateX = ReaderUtils.getChildText(geoTransformElement, "translateX");
            String translateY = ReaderUtils.getChildText(geoTransformElement, "translateY");
            geoTransform.put("scaleX", scaleX != null ? new Double(scaleX) : null);
            geoTransform.put("scaleY", scaleY != null ? new Double(scaleY) : null);
            geoTransform.put("shearX", shearX != null ? new Double(shearX) : null);
            geoTransform.put("shearY", shearY != null ? new Double(shearY) : null);
            geoTransform.put("translateX", translateX != null ? new Double(translateX) : null);
            geoTransform.put("translateY", translateY != null ? new Double(translateY) : null);
            grid.put("geoTransform", geoTransform);
        }
        return grid;
    }

    public List<Map> coverageDimensions() throws Exception {
        Element[] cdElements = ReaderUtils.getChildElements(this.coverage, "CoverageDimension");
        ArrayList<Map> cds = new ArrayList<Map>();
        for (int i = 0; i < cdElements.length; ++i) {
            HashMap<String, Object> cd = new HashMap<String, Object>();
            cd.put("name", ReaderUtils.getChildText(cdElements[i], "name"));
            cd.put("description", ReaderUtils.getChildText(cdElements[i], "description"));
            Element intervalElement = ReaderUtils.getChildElement(cdElements[i], "interval");
            double min = Double.parseDouble(ReaderUtils.getChildText(intervalElement, "min"));
            double max = Double.parseDouble(ReaderUtils.getChildText(intervalElement, "max"));
            cd.put("min", min);
            cd.put("max", max);
            cds.add(cd);
        }
        return cds;
    }

    public List<String> requestCRSs() throws Exception {
        Element supportedCRS = ReaderUtils.getChildElement(this.coverage, "supportedCRSs");
        String[] requestCRS = ReaderUtils.getChildText(supportedCRS, "requestCRSs").trim().split(",");
        return Arrays.asList(requestCRS);
    }

    public List<String> responseCRSs() throws Exception {
        Element supportedCRS = ReaderUtils.getChildElement(this.coverage, "supportedCRSs");
        String[] responseCRS = ReaderUtils.getChildText(supportedCRS, "responseCRSs").trim().split(",");
        return Arrays.asList(responseCRS);
    }

    public String nativeFormat() throws Exception {
        Element supportedFormats = ReaderUtils.getChildElement(this.coverage, "supportedFormats");
        return ReaderUtils.getAttribute(supportedFormats, "nativeFormat", true);
    }

    public List<String> supportedFormats() throws Exception {
        Element supportedFormats = ReaderUtils.getChildElement(this.coverage, "supportedFormats");
        String[] formats = ReaderUtils.getChildText(supportedFormats, "formats").split(",");
        return Arrays.asList(formats);
    }

    public String defaultInterpolation() throws Exception {
        Element supportedFormats = ReaderUtils.getChildElement(this.coverage, "supportedInterpolations");
        return ReaderUtils.getAttribute(supportedFormats, "default", true);
    }

    public List<String> supportedInterpolations() throws Exception {
        Element supportedFormats = ReaderUtils.getChildElement(this.coverage, "supportedInterpolations");
        String[] interpolations = ReaderUtils.getChildText(supportedFormats, "interpolationMethods").split(",");
        return Arrays.asList(interpolations);
    }

    public Map<String, Serializable> parameters() {
        Element parameters = ReaderUtils.getChildElement(this.coverage, "parameters");
        if (parameters == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        Element[] parameter = ReaderUtils.getChildElements(parameters, "parameter");
        for (int i = 0; i < parameter.length; ++i) {
            String name = parameter[i].getAttribute("name");
            String value = parameter[i].getAttribute("value");
            map.put(name, (Serializable)((Object)value));
        }
        return map;
    }

    public String wmsPath() {
        return ReaderUtils.getChildText(this.coverage, "wmspath");
    }

    public String parentDirectoryName() {
        return this.parentDirectory.getName();
    }
}

