/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global.dto;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.vfny.geoserver.global.dto.CloneLibrary;
import org.vfny.geoserver.global.dto.DataTransferObject;
import org.vfny.geoserver.global.dto.EqualsLibrary;

public final class DataDTO
implements DataTransferObject {
    private Map dataStores;
    private Map formats;
    private Map nameSpaces;
    private Map featuresTypes;
    private Map coverages;
    private Map styles;
    private String defaultNameSpacePrefix;

    public DataDTO() {
    }

    public DataDTO(DataDTO dto) {
        if (dto == null) {
            throw new NullPointerException("Non null DataDTO required");
        }
        try {
            this.dataStores = CloneLibrary.clone(dto.getDataStores());
        }
        catch (Exception e) {
            this.dataStores = new HashMap();
        }
        try {
            this.formats = CloneLibrary.clone(dto.getFormats());
        }
        catch (Exception e) {
            this.formats = new HashMap();
        }
        try {
            this.nameSpaces = CloneLibrary.clone(dto.getNameSpaces());
        }
        catch (Exception e) {
            this.nameSpaces = new HashMap();
        }
        try {
            this.featuresTypes = CloneLibrary.clone(dto.getFeaturesTypes());
        }
        catch (Exception e) {
            this.featuresTypes = new HashMap();
        }
        try {
            this.coverages = CloneLibrary.clone(dto.getCoverages());
        }
        catch (Exception e) {
            this.coverages = new HashMap();
        }
        try {
            this.styles = CloneLibrary.clone(dto.getStyles());
        }
        catch (Exception e) {
            this.styles = new HashMap();
        }
        this.defaultNameSpacePrefix = dto.getDefaultNameSpacePrefix();
    }

    public Object clone() {
        return new DataDTO(this);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof DataDTO)) {
            return false;
        }
        DataDTO c = (DataDTO)other;
        boolean r = true;
        if (this.dataStores != null) {
            r = r && EqualsLibrary.equals(this.dataStores, c.getDataStores());
        } else if (c.getDataStores() != null) {
            return false;
        }
        if (this.formats != null) {
            r = r && EqualsLibrary.equals(this.formats, c.getFormats());
        } else if (c.getFormats() != null) {
            return false;
        }
        if (this.nameSpaces != null) {
            r = r && EqualsLibrary.equals(this.nameSpaces, c.getNameSpaces());
        } else if (c.getNameSpaces() != null) {
            return false;
        }
        if (this.featuresTypes != null) {
            r = r && EqualsLibrary.equals(this.featuresTypes, c.getFeaturesTypes());
        } else if (c.getFeaturesTypes() != null) {
            return false;
        }
        if (this.coverages != null) {
            r = r && EqualsLibrary.equals(this.coverages, c.getCoverages());
        } else if (c.getCoverages() != null) {
            return false;
        }
        if (this.styles != null) {
            r = r && EqualsLibrary.equals(this.styles, c.getStyles());
        } else if (c.getStyles() != null) {
            return false;
        }
        if (this.defaultNameSpacePrefix != null) {
            r = r && this.defaultNameSpacePrefix.equals(c.getDefaultNameSpacePrefix());
        } else if (c.getDefaultNameSpacePrefix() != null) {
            return false;
        }
        return r;
    }

    public int hashCode() {
        int r = 1;
        if (this.dataStores != null) {
            r *= ((Object)this.dataStores).hashCode();
        }
        if (this.formats != null) {
            r *= ((Object)this.formats).hashCode();
        }
        if (this.nameSpaces != null) {
            r *= ((Object)this.nameSpaces).hashCode();
        }
        if (this.featuresTypes != null) {
            r *= ((Object)this.featuresTypes).hashCode();
        }
        if (this.styles != null) {
            r *= ((Object)this.styles).hashCode();
        }
        if (this.coverages != null) {
            r *= ((Object)this.coverages).hashCode();
        }
        return r;
    }

    public Map getDataStores() {
        return this.dataStores;
    }

    public Map getFormats() {
        return this.formats;
    }

    public String getDefaultNameSpacePrefix() {
        return this.defaultNameSpacePrefix;
    }

    public Map getFeaturesTypes() {
        return this.featuresTypes;
    }

    public Map getNameSpaces() {
        return this.nameSpaces;
    }

    public Map getStyles() {
        return this.styles;
    }

    public void setDataStores(Map map) {
        if (map == null) {
            throw new NullPointerException("DataStores map must not be null. Use Collections.EMPTY_MAP if you must");
        }
        this.dataStores = new HashMap(map);
        if (map != null) {
            this.dataStores = map;
        }
    }

    public void setFormats(Map map) {
        if (map == null) {
            throw new NullPointerException("Formats map must not be null. Use Collections.EMPTY_MAP if you must");
        }
        this.formats = new HashMap(map);
        if (map != null) {
            this.formats = map;
        }
    }

    public void setDefaultNameSpacePrefix(String dnsp) {
        this.defaultNameSpacePrefix = dnsp;
        if (!this.nameSpaces.containsKey(dnsp)) {
            throw new NoSuchElementException("Invalid NameSpace Prefix for Default");
        }
    }

    public void setFeaturesTypes(Map map) {
        if (map == null) {
            throw new NullPointerException("FeatureTypeInfoDTO map must not be null. Use Collections.EMPTY_MAP if you must");
        }
        this.featuresTypes = map;
    }

    public void setNameSpaces(Map map) {
        if (map == null) {
            throw new NullPointerException("NameSpaceDTO map must not be null. Use Collections.EMPTY_MAP if you must");
        }
        this.nameSpaces = map;
    }

    public void setStyles(Map map) {
        if (map == null) {
            throw new NullPointerException("StyleInfoDTO map must not be null. Use Collections.EMPTY_MAP if you must");
        }
        this.styles = map;
    }

    public Map getCoverages() {
        return this.coverages;
    }

    public void setCoverages(Map coverages) {
        if (coverages == null) {
            throw new NullPointerException("CoverageInfoDTO map must not be null. Use Collections.EMPTY_MAP if you must");
        }
        this.coverages = coverages;
    }
}

