/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.geoserver.util.ReaderUtils;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.vfny.geoserver.global.ConfigurationException;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.dto.DataDTO;
import org.vfny.geoserver.global.dto.GeoServerDTO;
import org.vfny.geoserver.global.dto.WCSDTO;
import org.vfny.geoserver.global.dto.WFSDTO;
import org.vfny.geoserver.global.dto.WMSDTO;
import org.vfny.geoserver.global.xml.XMLConfigReader;

public class Config
implements ApplicationContextAware {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.global");
    WebApplicationContext context;
    XMLConfigReader reader;

    public File dataDirectory() {
        return GeoserverDataDirectory.getGeoserverDataDirectory();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = (WebApplicationContext)context;
        ServletContext sc = this.context.getServletContext();
        try {
            GeoserverDataDirectory.init(this.context);
            try {
                this.doConfigSanityCheck();
            }
            catch (ConfigurationException ce) {
                LOGGER.severe(ce.getMessage());
                throw new BeanInitializationException(ce.getMessage());
            }
            this.reader = new XMLConfigReader(this.dataDirectory(), sc);
        }
        catch (ConfigurationException e) {
            String msg = "Error creating xml config reader";
            throw new BeanInitializationException(msg, (Throwable)e);
        }
    }

    private void doConfigSanityCheck() throws ConfigurationException {
        File dataDirectory = this.dataDirectory();
        try {
            ReaderUtils.checkFile((File)dataDirectory, (boolean)true);
        }
        catch (FileNotFoundException e) {
            throw new ConfigurationException("Can't access the configuration directory. Reason: " + e.getMessage());
        }
    }

    public WebApplicationContext getApplictionContext() {
        return this.context;
    }

    public DataDTO getData() {
        return this.reader.getData();
    }

    public GeoServerDTO getGeoServer() {
        return this.reader.getGeoServer();
    }

    public WMSDTO getWms() {
        return this.reader.getWms();
    }

    public WFSDTO getWfs() {
        return this.reader.getWfs();
    }

    public WCSDTO getWcs() {
        return this.reader.getWcs();
    }
}

